/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.steps;

import java.io.IOException;
import java.nio.file.Path;
import org.bonitasoft.web.angularjs.export.IncludeChildDirectoryPredicate;
import org.bonitasoft.web.designer.common.export.ExportStep;
import org.bonitasoft.web.designer.common.export.Zipper;
import org.bonitasoft.web.designer.common.visitor.FragmentIdVisitor;
import org.bonitasoft.web.designer.model.page.AbstractPage;

public class FragmentsExportStep<T extends AbstractPage>
implements ExportStep<T> {
    private final FragmentIdVisitor fragmentIdVisitor;
    private final Path fragmentsPath;

    public FragmentsExportStep(FragmentIdVisitor fragmentIdVisitor, Path fragmentsPath) {
        this.fragmentIdVisitor = fragmentIdVisitor;
        this.fragmentsPath = fragmentsPath;
    }

    public void execute(Zipper zipper, T artifact) throws IOException {
        zipper.addDirectoryToZip(this.fragmentsPath, (Zipper.PathPredicate)new IncludeChildDirectoryPredicate(this.fragmentsPath, this.fragmentIdVisitor.visit(artifact)), Zipper.ALL_FILES, "resources/fragments");
    }
}

