/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.bonitasoft.web.designer.common.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.controller.importer.AbstractArtifactImporter;
import org.bonitasoft.web.designer.controller.importer.Import;

public class ImportStore {
    private final Map<String, Import> extractedDirPathMap = new ConcurrentHashMap<String, Import>();

    public Import store(AbstractArtifactImporter<?> importer, Path path) {
        path.toFile().deleteOnExit();
        String uuid = UUID.randomUUID().toString();
        Import anImport = new Import(importer, uuid, path);
        this.extractedDirPathMap.put(uuid, anImport);
        return anImport;
    }

    public void remove(String uuid) {
        Import anImport = this.extractedDirPathMap.remove(uuid);
        if (anImport != null) {
            FileUtils.deleteQuietly((File)anImport.getPath().toFile());
        }
    }

    public Import get(String uuid) {
        Import anImport = this.extractedDirPathMap.get(uuid);
        if (anImport == null) {
            throw new NotFoundException();
        }
        return anImport;
    }
}

