/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer.dependencies;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.web.designer.common.repository.AssetRepository;
import org.bonitasoft.web.designer.common.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.controller.importer.dependencies.DependencyImporter;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.widget.Widget;

public class AssetDependencyImporter<T extends Identifiable & Assetable>
implements DependencyImporter<Asset> {
    public static final String ASSETS_FOLDER_NAME = "assets";
    private final AssetRepository<T> assetRepository;

    public AssetDependencyImporter(AssetRepository<T> assetRepository) {
        this.assetRepository = assetRepository;
    }

    @Override
    public List<Asset> load(Identifiable component, Path resources) throws IOException {
        Path assetsPath;
        Path path = assetsPath = component instanceof Widget ? this.getWidgetAssetsFolderPath(component.getId(), resources) : resources.resolve(ASSETS_FOLDER_NAME);
        if (Files.exists(assetsPath, new LinkOption[0])) {
            ArrayList<Asset> assets = new ArrayList<Asset>();
            for (AssetType type : AssetType.values()) {
                Path path2 = assetsPath.resolve(type.getPrefix());
                if (!Files.exists(path2, new LinkOption[0])) continue;
                assets.addAll(this.assetRepository.findAssetInPath(component, type, path2));
            }
            return assets;
        }
        return new ArrayList<Asset>();
    }

    private Path getWidgetAssetsFolderPath(String componentId, Path resources) {
        Path assetsPath = resources.resolve(componentId).resolve(ASSETS_FOLDER_NAME);
        return Files.exists(assetsPath, new LinkOption[0]) ? assetsPath : resources.resolve(ASSETS_FOLDER_NAME);
    }

    @Override
    public void save(List<Asset> elements, Path resources) {
        for (Asset asset : elements) {
            Path assetsPath = "widget".equals(asset.getScope()) ? this.getWidgetAssetsFolderPath(asset.getComponentId(), resources) : resources.resolve(ASSETS_FOLDER_NAME);
            Path sourceFile = assetsPath.resolve(asset.getType().getPrefix()).resolve(asset.getName());
            try {
                this.assetRepository.save(asset, Files.readAllBytes(sourceFile));
            }
            catch (IOException e) {
                throw new RepositoryException(String.format("Impossible to save the source file [%s] as new %s asset ", sourceFile.getFileName().toString(), asset.getType()), (Throwable)e);
            }
        }
    }
}

