/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer.dependencies;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.controller.importer.ImportException;
import org.bonitasoft.web.designer.controller.importer.dependencies.AssetDependencyImporter;
import org.bonitasoft.web.designer.controller.importer.dependencies.ComponentDependencyImporter;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WidgetDependencyImporter
extends ComponentDependencyImporter<Widget> {
    private static final Logger log = LoggerFactory.getLogger(WidgetDependencyImporter.class);
    private final WidgetRepository widgetRepository;
    private final AssetDependencyImporter<Widget> widgetAssetDependencyImporter;

    public WidgetDependencyImporter(WidgetRepository widgetRepository, AssetDependencyImporter<Widget> widgetAssetDependencyImporter) {
        super(widgetRepository);
        this.widgetRepository = widgetRepository;
        this.widgetAssetDependencyImporter = widgetAssetDependencyImporter;
    }

    @Override
    public List<Widget> load(Identifiable parent, Path resources) throws IOException {
        Path widgetsPath = resources.resolve("widgets");
        if (Files.exists(widgetsPath, new LinkOption[0])) {
            return this.widgetRepository.loadAll(widgetsPath, WidgetRepository.CUSTOM_WIDGET_FILTER);
        }
        return new ArrayList<Widget>();
    }

    @Override
    public void save(List<Widget> elements, Path resources) {
        this.widgetRepository.saveAll(elements);
        Path widgetPath = resources.resolve("widgets");
        for (Widget widget : elements) {
            try {
                List<Asset> assets = this.widgetAssetDependencyImporter.load((Identifiable)widget, widgetPath);
                this.widgetAssetDependencyImporter.save(assets, widgetPath);
            }
            catch (IOException e) {
                String error = String.format("Technical error when importing widget asset [%s]", widget.getId());
                log.error(error, (Throwable)e);
                throw new ImportException(ImportException.Type.UNEXPECTED_ZIP_STRUCTURE, error);
            }
        }
    }
}

