/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.i18n;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bonitasoft.web.designer.ArtifactBuilderException;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.fedorahosted.tennera.jgettext.Catalog;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.PoParser;

public class LanguagePack {
    private final File poFile;
    private final JsonHandler jsonHandler;

    public byte[] toJson() throws IOException {
        HashMap language = new HashMap();
        HashMap translations = new HashMap();
        Catalog catalog = new PoParser().parseCatalog(this.poFile);
        language.put(this.extractLanguageFrom(catalog.locateHeader()), translations);
        catalog.processMessages(message -> {
            if (this.isHeader(message)) {
                return;
            }
            translations.put(message.getMsgid(), this.isPlural(message) ? message.getMsgstrPlural() : message.getMsgstr());
        });
        return this.jsonHandler.toJson(language);
    }

    private String extractLanguageFrom(Message header) {
        Matcher matcher = Pattern.compile("Language:(.*)$", 8).matcher(header.getMsgstr());
        if (!matcher.find()) {
            throw new ArtifactBuilderException("Couldn't find po file language.");
        }
        return matcher.group(1).trim();
    }

    private boolean isHeader(Message message) {
        return message.getMsgid() == null || message.getMsgid().isEmpty();
    }

    private boolean isPlural(Message message) {
        return message.getMsgstr() == null;
    }

    public LanguagePack(File poFile, JsonHandler jsonHandler) {
        this.poFile = poFile;
        this.jsonHandler = jsonHandler;
    }
}

