/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.i18n;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.bonitasoft.web.angularjs.GeneratorProperties;
import org.bonitasoft.web.designer.common.livebuild.AbstractLiveFileBuilder;
import org.bonitasoft.web.designer.common.livebuild.Watcher;
import org.bonitasoft.web.designer.i18n.LanguagePackFactory;

public class LanguagePackBuilder
extends AbstractLiveFileBuilder {
    private final LanguagePackFactory languagePackFactory;
    private final GeneratorProperties generatorProperties;

    public LanguagePackBuilder(Watcher watcher, LanguagePackFactory languagePackFactory, GeneratorProperties generatorProperties) {
        super(watcher, generatorProperties.isLiveBuildEnabled());
        this.languagePackFactory = languagePackFactory;
        this.generatorProperties = generatorProperties;
    }

    public void build(Path poFile) throws IOException {
        String jsonFileName = poFile.getFileName().toString().replace(".po", ".json");
        Files.write(this.generatorProperties.getTmpI18nPath().resolve(jsonFileName), this.languagePackFactory.create(poFile.toFile()).toJson(), new OpenOption[0]);
    }

    public boolean isBuildable(String path) {
        return path.endsWith(".po");
    }
}

