/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.util.Optional;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetExternalMigrationStep<A extends Identifiable & Assetable>
extends AbstractMigrationStep<A> {
    private static final Logger logger = LoggerFactory.getLogger(AssetExternalMigrationStep.class);

    public static boolean isAssetURL(String name) {
        return name != null && (name.startsWith("http:") || name.startsWith("https:"));
    }

    @Override
    public Optional<MigrationStepReport> migrate(A artifact) {
        for (Asset asset : ((Assetable)artifact).getAssets()) {
            asset.setExternal(AssetExternalMigrationStep.isAssetURL(asset.getName()));
            logger.info("[MIGRATION] Asset <{}> with id <{}> has been identified as {} (external property was introduced in 1.2)", new Object[]{asset.getName(), asset.getId(), asset.isExternal() ? "external" : "internal"});
        }
        return Optional.empty();
    }
}

