/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import java.util.Map;
import java.util.Optional;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.migration.MigrationStep;
import org.bonitasoft.web.designer.migration.page.BondMigrationStrategy;
import org.bonitasoft.web.designer.migration.page.ConstantBondMigrationStrategy;
import org.bonitasoft.web.designer.migration.page.ExpressionBondMigrationStrategy;
import org.bonitasoft.web.designer.migration.page.InterpolationBondMigrationStrategy;
import org.bonitasoft.web.designer.migration.page.VariableBondMigrationStrategy;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.model.widget.BondType;
import org.bonitasoft.web.designer.model.widget.Property;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.visitor.ComponentVisitor;
import org.bonitasoft.web.designer.visitor.ElementVisitor;
import org.bonitasoft.web.designer.visitor.VisitorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BondMigrationStep<T extends AbstractPage>
implements MigrationStep<T> {
    private static final Logger logger = LoggerFactory.getLogger(BondMigrationStep.class);
    private final ComponentVisitor componentVisitor;
    private final WidgetRepository widgetRepository;
    private final VisitorFactory visitorFactory;
    private final Map<BondType, BondMigrationStrategy> migrationStrategies = Map.of(BondType.CONSTANT, new ConstantBondMigrationStrategy(), BondType.INTERPOLATION, new InterpolationBondMigrationStrategy(), BondType.EXPRESSION, new ExpressionBondMigrationStrategy(), BondType.VARIABLE, new VariableBondMigrationStrategy());

    public BondMigrationStep(ComponentVisitor componentVisitor, WidgetRepository widgetRepository, VisitorFactory visitorFactory) {
        this.componentVisitor = componentVisitor;
        this.widgetRepository = widgetRepository;
        this.visitorFactory = visitorFactory;
    }

    @Override
    public Optional<MigrationStepReport> migrate(AbstractPage page) {
        for (Component component : (Iterable)page.accept((ElementVisitor)this.componentVisitor)) {
            Widget widget = (Widget)this.widgetRepository.get(component.getId());
            for (Map.Entry<String, PropertyValue> entry : component.getPropertyValues().entrySet()) {
                Property property = widget.getProperty((String)entry.getKey());
                String formerType = ((PropertyValue)entry.getValue()).getType();
                this.migrationStrategies.get(property != null ? property.getBond() : BondType.EXPRESSION).migrate(property, (PropertyValue)entry.getValue());
                this.logTypeChange(component.getId(), formerType, entry);
            }
        }
        for (Element element : (Iterable)page.accept((ElementVisitor)this.visitorFactory.createAnyContainerVisitor())) {
            for (Map.Entry<String, PropertyValue> entry : element.getPropertyValues().entrySet()) {
                this.migrationStrategies.get(BondType.EXPRESSION).migrate(new Property(), (PropertyValue)entry.getValue());
                this.logTypeChange(element.getClass().getSimpleName(), ((PropertyValue)entry.getValue()).getType(), entry);
            }
        }
        return Optional.empty();
    }

    private void logTypeChange(String name, String formerType, Map.Entry<String, PropertyValue> entry) {
        String currentType = entry.getValue().getType();
        if (!formerType.equals(currentType)) {
            logger.info("[MIGRATION] {} property <{}> value type has been changed from <{}> to <{}>", new Object[]{name, entry.getKey(), formerType, currentType});
        }
    }

    @Override
    public String getErrorMessage() {
        return "";
    }
}

