/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.web.designer.ArtifactBuilderException;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.visitor.ComponentVisitor;
import org.bonitasoft.web.designer.visitor.ElementVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIBootstrapAssetMigrationStep
extends AbstractMigrationStep<Page> {
    public static final String ASSET_FILE_NAME = "ui-bootstrap-tpls-0.13.0.min.js";
    private static final Logger logger = LoggerFactory.getLogger(UIBootstrapAssetMigrationStep.class);
    private final AssetService<Page> pageAssetService;
    private final ComponentVisitor componentVisitor;
    private final WidgetRepository widgetRepository;

    public UIBootstrapAssetMigrationStep(AssetService<Page> pageAssetService, ComponentVisitor componentVisitor, WidgetRepository widgetRepository) {
        this.pageAssetService = pageAssetService;
        this.componentVisitor = componentVisitor;
        this.widgetRepository = widgetRepository;
    }

    @Override
    public Optional<MigrationStepReport> migrate(Page page) {
        if (!this.pageHasAsset(page, "ui-bootstrap") && !this.widgetHasAsset(page, "ui-bootstrap")) {
            Asset uiBootstrap = new Asset().setName(ASSET_FILE_NAME).setType(AssetType.JAVASCRIPT);
            this.pageAssetService.save(page, uiBootstrap, this.getContent());
            String msg = String.format("Adding %s asset [%s] to [%s] (as it was removed from vendor.min.js). You can remove it if you don't need it.", uiBootstrap.getType(), uiBootstrap.getName(), page.getName());
            logger.info(msg);
            return Optional.of(MigrationStepReport.warningMigrationReport((String)page.getName(), (String)msg, (String)this.getClass().getName()));
        }
        return Optional.empty();
    }

    @Override
    public String getErrorMessage() {
        return "An error occurs during ui-bootstrap asset migration";
    }

    private boolean widgetHasAsset(Page page, String assetNameFilter) {
        for (Component component : (Iterable)page.accept((ElementVisitor)this.componentVisitor)) {
            Widget widget = (Widget)this.widgetRepository.get(component.getId());
            if (!widget.isCustom()) continue;
            for (Asset asset : widget.getAssets()) {
                if (!asset.getName().contains(assetNameFilter) || !AssetType.JAVASCRIPT.equals((Object)asset.getType())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean pageHasAsset(Page page, String assetPrefix) {
        for (Asset asset : page.getAssets()) {
            if (!asset.getName().contains(assetPrefix) || !AssetType.JAVASCRIPT.equals((Object)asset.getType())) continue;
            return true;
        }
        return false;
    }

    public byte[] getContent() {
        byte[] byArray;
        block8: {
            InputStream is = this.getClass().getResourceAsStream(ASSET_FILE_NAME);
            try {
                byArray = IOUtils.toByteArray((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ArtifactBuilderException("Missing " + this.getClass().getPackage() + "/ui-bootstrap-tpls-0.13.0.min.js from classpath", e);
                }
            }
            is.close();
        }
        return byArray;
    }
}

