/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bonitasoft.web.designer.common.repository.AbstractRepository;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.common.repository.PageRepository;
import org.bonitasoft.web.designer.common.repository.Repository;
import org.bonitasoft.web.designer.common.repository.exception.InUseException;
import org.bonitasoft.web.designer.common.repository.exception.NotAllowedException;
import org.bonitasoft.web.designer.common.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.common.visitor.AssetVisitor;
import org.bonitasoft.web.designer.common.visitor.FragmentIdVisitor;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.controller.Predicates;
import org.bonitasoft.web.designer.controller.asset.PageAssetPredicate;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.ModelException;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.migrationReport.MigrationResult;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStatus;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.WebResource;
import org.bonitasoft.web.designer.service.AbstractArtifactService;
import org.bonitasoft.web.designer.service.FragmentMigrationApplyer;
import org.bonitasoft.web.designer.service.FragmentService;
import org.bonitasoft.web.designer.visitor.FragmentChangeVisitor;
import org.bonitasoft.web.designer.visitor.PageHasValidationErrorVisitor;
import org.bonitasoft.web.designer.visitor.WebResourcesVisitor;
import org.springframework.util.StringUtils;

public class DefaultFragmentService
extends AbstractArtifactService<FragmentRepository, Fragment>
implements FragmentService {
    private final FragmentMigrationApplyer fragmentMigrationApplyer;
    private final FragmentIdVisitor fragmentIdVisitor;
    private final FragmentChangeVisitor fragmentChangeVisitor;
    private final PageHasValidationErrorVisitor pageHasValidationErrorVisitor;
    private final AssetVisitor assetVisitor;
    private final PageRepository pageRepository;
    private final List<Repository<?>> usedByRepositories;
    private final WebResourcesVisitor webResourcesVisitor;

    public DefaultFragmentService(FragmentRepository fragmentRepository, PageRepository pageRepository, FragmentMigrationApplyer fragmentMigrationApplyer, FragmentIdVisitor fragmentIdVisitor, FragmentChangeVisitor fragmentChangeVisitor, PageHasValidationErrorVisitor pageHasValidationErrorVisitor, AssetVisitor assetVisitor, UiDesignerProperties uiDesignerProperties, WebResourcesVisitor webResourcesVisitor) {
        super(uiDesignerProperties, fragmentRepository);
        this.pageRepository = pageRepository;
        this.fragmentMigrationApplyer = fragmentMigrationApplyer;
        this.fragmentIdVisitor = fragmentIdVisitor;
        this.fragmentChangeVisitor = fragmentChangeVisitor;
        this.pageHasValidationErrorVisitor = pageHasValidationErrorVisitor;
        this.assetVisitor = assetVisitor;
        this.usedByRepositories = Arrays.asList(pageRepository, this.repository);
        this.webResourcesVisitor = webResourcesVisitor;
    }

    @Override
    public Fragment get(String id) {
        Fragment fragment = (Fragment)((FragmentRepository)this.repository).get(id);
        return this.migrate(fragment);
    }

    @Override
    public List<Fragment> getAllNotUsingFragment(String elementId) {
        List<Object> fragments = StringUtils.hasText((String)elementId) ? ((FragmentRepository)this.repository).getAllNotUsingElement(elementId) : ((FragmentRepository)this.repository).getAll();
        fragments = fragments.stream().map(f -> {
            f.setStatus(this.getStatus((Fragment)f));
            return f;
        }).collect(Collectors.toList());
        this.fillWithUsedBy(fragments);
        return fragments;
    }

    @Override
    public Fragment getWithAsset(String id) {
        Fragment fragment = (Fragment)((FragmentRepository)this.repository).get(id);
        fragment = this.migrate(fragment);
        fragment.setAssets(this.assetVisitor.visit((Previewable)fragment));
        return fragment;
    }

    @Override
    public Fragment migrate(Fragment fragment) {
        MigrationResult<Fragment> result = this.migrate(fragment, true);
        return (Fragment)result.getArtifact();
    }

    @Override
    public MigrationResult<Fragment> migrateWithReport(Fragment fragment) {
        return this.migrate(fragment, true);
    }

    @Override
    public ArtifactStatusReport getStatus(Fragment fragment) {
        ArtifactStatusReport fragmentStatusReport = super.getStatus(fragment);
        ArtifactStatusReport depWidgetReport = this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment);
        ArtifactStatusReport depFragmentReport = this.getArtifactStatusOfFragmentUsed((Previewable)fragment);
        return this.mergeStatusReport(fragmentStatusReport, this.mergeStatusReport(depWidgetReport, depFragmentReport));
    }

    @Override
    public MigrationResult<Fragment> migrate(Fragment fragmentToMigrate, boolean migrateChildren) {
        fragmentToMigrate.setStatus(this.getStatus(fragmentToMigrate));
        if (!fragmentToMigrate.getStatus().isMigration()) {
            return new MigrationResult((Object)fragmentToMigrate, Collections.emptyList());
        }
        MigrationResult<Fragment> migratedResult = this.fragmentMigrationApplyer.migrate(fragmentToMigrate, migrateChildren);
        Fragment fragmentMigrated = (Fragment)migratedResult.getArtifact();
        if (!migratedResult.getFinalStatus().equals((Object)MigrationStatus.ERROR)) {
            ((FragmentRepository)this.repository).updateLastUpdateAndSave((Identifiable)fragmentMigrated);
        }
        if (migrateChildren) {
            migratedResult.getMigrationStepReportList().addAll(this.migrateAllFragmentUsed((Previewable)fragmentToMigrate));
        }
        return migratedResult;
    }

    @Override
    public List<MigrationStepReport> migrateAllFragmentUsed(Previewable previewable) {
        ArrayList<MigrationStepReport> report = new ArrayList<MigrationStepReport>();
        ((FragmentRepository)this.repository).getByIds(this.fragmentIdVisitor.visit(previewable)).forEach(p -> {
            MigrationResult<Fragment> migratedResult = this.migrate((Fragment)p, false);
            report.addAll(migratedResult.getMigrationStepReportListFilterByFinalStatus());
        });
        return report;
    }

    @Override
    public ArtifactStatusReport getArtifactStatusOfFragmentUsed(Previewable previewable) {
        ArrayList reports = new ArrayList();
        ((FragmentRepository)this.repository).getByIds(this.fragmentIdVisitor.visit(previewable)).forEach(fragment -> reports.add(this.getStatus((Fragment)fragment)));
        boolean migration = false;
        for (ArtifactStatusReport report : reports) {
            if (!report.isCompatible()) {
                return report;
            }
            if (migration || !report.isMigration()) continue;
            migration = true;
        }
        return new ArtifactStatusReport(true, migration);
    }

    @Override
    public Fragment rename(Fragment fragment, String name) throws ModelException {
        this.checkIfFragmentIsCompatible(fragment);
        String fragmentId = fragment.getId();
        String newFragmentId = ((FragmentRepository)this.repository).getNextAvailableId(name);
        this.updateReferencesParentArtifacts(fragment, newFragmentId, fragment.getHasValidationError());
        fragment.setId(newFragmentId);
        fragment.setName(name);
        this.checkNameIsUnique(((FragmentRepository)this.repository).getAll().stream().filter(Predicates.propertyEqualTo("id", fragmentId).negate()).collect(Collectors.toList()), fragment);
        Fragment savedFragment = (Fragment)((FragmentRepository)this.repository).updateLastUpdateAndSave((Identifiable)fragment);
        ((FragmentRepository)this.repository).delete(fragmentId);
        return savedFragment;
    }

    @Override
    public Fragment create(Fragment fragment) {
        this.checkNameIsUnique(((FragmentRepository)this.repository).getAll(), fragment);
        fragment.setId(((FragmentRepository)this.repository).getNextAvailableId(fragment.getName()));
        fragment.setAssets(fragment.getAssets().stream().filter(new PageAssetPredicate()).collect(Collectors.toSet()));
        return (Fragment)((FragmentRepository)this.repository).updateLastUpdateAndSave((Identifiable)fragment);
    }

    @Override
    public Fragment save(String fragmentId, Fragment fragment) throws ModelException {
        String newFragmentId;
        this.checkNameIsUnique(((FragmentRepository)this.repository).getAll().stream().filter(Predicates.propertyEqualTo("id", fragment.getId()).negate()).collect(Collectors.toList()), fragment);
        try {
            boolean validationErrorStateChanged;
            Fragment currentFragment = this.get(fragmentId);
            this.checkIfFragmentIsCompatible(currentFragment);
            boolean nameChanged = !currentFragment.getName().equals(fragment.getName());
            boolean bl = validationErrorStateChanged = currentFragment.getHasValidationError() != fragment.getHasValidationError();
            if (validationErrorStateChanged || nameChanged) {
                newFragmentId = nameChanged ? ((FragmentRepository)this.repository).getNextAvailableId(fragment.getName()) : fragmentId;
                this.updateReferencesParentArtifacts(currentFragment, newFragmentId, fragment.getHasValidationError());
            } else {
                newFragmentId = fragmentId;
            }
        }
        catch (NotFoundException e) {
            newFragmentId = ((FragmentRepository)this.repository).getNextAvailableId(fragment.getName());
        }
        fragment.setId(newFragmentId);
        fragment.setAssets(fragment.getAssets().stream().filter(new PageAssetPredicate()).collect(Collectors.toSet()));
        Fragment savedFragment = (Fragment)((FragmentRepository)this.repository).updateLastUpdateAndSave((Identifiable)fragment);
        if (!fragmentId.equals(savedFragment.getId())) {
            ((FragmentRepository)this.repository).delete(fragmentId);
        }
        return savedFragment;
    }

    @Override
    public void delete(String fragmentId) {
        Fragment fragment = new Fragment();
        fragment.setId(fragmentId);
        this.fillWithUsedBy(fragment);
        if (fragment.isUsed()) {
            throw new InUseException(this.buildErrorMessage(fragment));
        }
        ((FragmentRepository)this.repository).delete(fragmentId);
    }

    private String buildErrorMessage(Fragment fragment) {
        StringBuilder msg = new StringBuilder("The fragment cannot be deleted because it is used in");
        fragment.getUsedBy().forEach((key, elements) -> {
            if (!elements.isEmpty()) {
                msg.append(" ").append(elements.size()).append(" ").append((String)key).append(elements.size() > 1 ? "s" : "").append(" ").append(elements.stream().map(elem -> "<" + elem.getName() + ">").collect(Collectors.joining(", ")));
            }
        });
        return msg.toString();
    }

    private void checkNameIsUnique(Collection<Fragment> fragments, Fragment fragment) {
        NotAllowedException.checkNotAllowed((boolean)fragments.stream().anyMatch(Predicates.propertyEqualTo("name", fragment.getName())), (String)String.format("A fragment with name %s already exists", fragment.getName()));
    }

    private void checkIfFragmentIsCompatible(Fragment fragment) throws ModelException {
        if (fragment.getStatus() != null && !fragment.getStatus().isCompatible()) {
            String message = String.format("Fragment %s is in an incompatible version. Newer UI Designer version is required.", fragment.getId());
            throw new ModelException(message);
        }
    }

    private void updateReferencesParentArtifacts(Fragment currentFragment, String newFragmentId, boolean newHasValidationError) {
        this.fillWithUsedBy(currentFragment);
        if (currentFragment.getUsedBy() == null) {
            return;
        }
        String oldFragmentId = currentFragment.getId();
        for (Map.Entry entry : currentFragment.getUsedBy().entrySet()) {
            List identifiables = (List)entry.getValue();
            List pages = identifiables.stream().filter(Page.class::isInstance).collect(Collectors.toList());
            this.updateReference(pages, newFragmentId, oldFragmentId, (AbstractRepository)this.pageRepository, newHasValidationError);
            List fragments = identifiables.stream().filter(identifiable -> identifiable.getType().equals("fragment")).collect(Collectors.toList());
            this.updateReference(fragments, newFragmentId, oldFragmentId, (AbstractRepository)this.repository, newHasValidationError);
        }
    }

    private <T extends AbstractPage> void updateReference(List<? extends Identifiable> artifacts, String newFragmentId, String oldFragmentId, AbstractRepository repo, boolean newHasValidationError) {
        this.fragmentChangeVisitor.setNewFragmentId(newFragmentId);
        this.fragmentChangeVisitor.setFragmentToReplace(oldFragmentId);
        artifacts.forEach(identifiable -> {
            AbstractPage artifact = (AbstractPage)repo.get(identifiable.getId());
            if (newHasValidationError != artifact.getHasValidationError()) {
                this.updateArtifactValidationError(artifact, newHasValidationError, newFragmentId);
                if (artifact.getClass().equals(Fragment.class)) {
                    this.updateReferencesParentArtifacts((Fragment)artifact, artifact.getId(), newHasValidationError);
                }
            }
            List rows = artifact.getRows();
            this.fragmentChangeVisitor.visitRows(rows);
            repo.updateLastUpdateAndSave((Identifiable)artifact);
        });
    }

    private void updateArtifactValidationError(AbstractPage artifact, boolean newHasValidationError, String newFragmentId) {
        if (newHasValidationError) {
            artifact.setHasValidationError(true);
        } else if (!this.containsValidationError(artifact, newFragmentId)) {
            artifact.setHasValidationError(false);
        }
    }

    private boolean containsValidationError(AbstractPage page, String newFragmentId) {
        boolean hasValidationError = false;
        for (List row : page.getRows()) {
            for (Element element : row) {
                if (element.getClass().equals(FragmentElement.class)) {
                    if (((FragmentElement)element).getId().equals(newFragmentId)) continue;
                    hasValidationError = hasValidationError || element.getHasValidationError();
                    continue;
                }
                hasValidationError = hasValidationError || this.pageHasValidationErrorVisitor.visit((Component)element);
            }
        }
        return hasValidationError;
    }

    private void fillWithUsedBy(Fragment fragment) {
        this.fillWithUsedBy(List.of(fragment));
    }

    private void fillWithUsedBy(List<Fragment> fragments) {
        ArrayList<String> fragmentIds = new ArrayList<String>();
        for (Fragment fragment : fragments) {
            fragmentIds.add(fragment.getId());
        }
        for (Repository repository : this.usedByRepositories) {
            Map map = repository.findByObjectIds(fragmentIds);
            for (Fragment fragment : fragments) {
                fragment.addUsedBy(repository.getComponentName(), (List)map.get(fragment.getId()));
            }
        }
    }

    @Override
    public Set<Asset> listAsset(Fragment fragment) {
        return this.assetVisitor.visit((Previewable)fragment);
    }

    @Override
    public List<WebResource> detectAutoWebResources(Fragment fragment) {
        Object resources = this.webResourcesVisitor.visit((Previewable)fragment);
        return resources.values().stream().collect(Collectors.toList());
    }
}

