/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.controller.importer.dependencies.AssetDependencyImporter;
import org.bonitasoft.web.designer.controller.importer.dependencies.FragmentDependencyImporter;
import org.bonitasoft.web.designer.controller.importer.dependencies.WidgetDependencyImporter;
import org.bonitasoft.web.designer.controller.importer.report.ImportReport;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
class ImportReportTest {
    @Mock
    private WidgetDependencyImporter widgetDependencyImporter;
    @Mock
    private FragmentDependencyImporter fragmentDependencyImporter;
    @Mock
    private AssetDependencyImporter assetDependencyImporter;

    ImportReportTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        Mockito.when((Object)this.widgetDependencyImporter.getComponentName()).thenReturn((Object)"widget");
        Mockito.when((Object)this.fragmentDependencyImporter.getComponentName()).thenReturn((Object)"fragment");
    }

    private Widget existing(Widget widget) {
        Mockito.when((Object)((Widget)this.widgetDependencyImporter.getOriginalElementFromRepository((Identifiable)widget))).thenReturn((Object)widget);
        Mockito.when((Object)this.widgetDependencyImporter.exists((Identifiable)widget)).thenReturn((Object)true);
        return widget;
    }

    @Test
    void should_report_imported_element_when_it_is_a_page() throws Exception {
        Page importedPage = PageBuilder.aPage().build();
        ImportReport report = ImportReport.from((Identifiable)importedPage, new HashMap());
        Assertions.assertThat((Object)report.getElement()).isEqualTo((Object)importedPage);
    }

    @Test
    void should_report_imported_element_when_it_is_a_widget() throws Exception {
        Widget importedWidget = WidgetBuilder.aWidget().build();
        ImportReport report = ImportReport.from((Identifiable)importedWidget, new HashMap());
        Assertions.assertThat((Object)report.getElement()).isEqualTo((Object)importedWidget);
    }

    @Test
    void should_include_added_and_overriden_widget_in_imported_dependencies() throws Exception {
        Widget existingWidget = this.existing(WidgetBuilder.aWidget().withId("existing").build());
        Widget newWidget = WidgetBuilder.aWidget().withId("newOne").build();
        HashMap<WidgetDependencyImporter, List<Widget>> dependencies = new HashMap<WidgetDependencyImporter, List<Widget>>();
        dependencies.put(this.widgetDependencyImporter, Arrays.asList(newWidget, existingWidget));
        ImportReport report = ImportReport.from((Identifiable)PageBuilder.aPage().build(), dependencies);
        Assertions.assertThat((List)((List)report.getDependencies().getAdded().get("widget"))).containsOnly(new Object[]{newWidget});
        Assertions.assertThat((List)((List)report.getDependencies().getOverwritten().get("widget"))).containsOnly(new Object[]{existingWidget});
    }

    @Test
    void should_not_include_assets_in_imported_dependencies() throws Exception {
        HashMap<AssetDependencyImporter, List<Asset>> dependencies = new HashMap<AssetDependencyImporter, List<Asset>>();
        dependencies.put(this.assetDependencyImporter, Arrays.asList(AssetBuilder.anAsset().build()));
        ImportReport report = ImportReport.from((Identifiable)PageBuilder.aPage().build(), dependencies);
        Assertions.assertThat((Map)report.getDependencies().getAdded()).isNull();
        Assertions.assertThat((Map)report.getDependencies().getOverwritten()).isNull();
    }

    private Fragment mockExistsInRepository(Fragment fragment) {
        Mockito.when((Object)this.fragmentDependencyImporter.exists((Identifiable)fragment)).thenReturn((Object)true);
        Mockito.when((Object)((Fragment)this.fragmentDependencyImporter.getOriginalElementFromRepository((Identifiable)fragment))).thenReturn((Object)fragment);
        return fragment;
    }

    private Widget mockExistsInRepository(Widget widget) {
        Mockito.when((Object)this.widgetDependencyImporter.exists((Identifiable)widget)).thenReturn((Object)true);
        Mockito.when((Object)((Widget)this.widgetDependencyImporter.getOriginalElementFromRepository((Identifiable)widget))).thenReturn((Object)widget);
        return widget;
    }

    @Test
    void should_report_imported_element_when_it_is_a_fragment() throws Exception {
        Fragment importedFragment = FragmentBuilder.aFragment().build();
        ImportReport report = ImportReport.from((Identifiable)importedFragment, new HashMap());
        Assertions.assertThat((Object)report.getElement()).isEqualTo((Object)importedFragment);
    }

    @Test
    void should_include_added_and_overwritten_widget_in_imported_dependencies() throws Exception {
        Widget newWidget = WidgetBuilder.aWidget().withId("newOne").build();
        Widget existingWidget = this.mockExistsInRepository(WidgetBuilder.aWidget().withId("existing").build());
        HashMap<WidgetDependencyImporter, List<Widget>> dependencies = new HashMap<WidgetDependencyImporter, List<Widget>>();
        dependencies.put(this.widgetDependencyImporter, Arrays.asList(newWidget, existingWidget));
        ImportReport report = ImportReport.from((Identifiable)FragmentBuilder.aFragment().build(), dependencies);
        Assertions.assertThat((List)((List)report.getDependencies().getAdded().get("widget"))).containsOnly(new Object[]{newWidget});
        Assertions.assertThat((List)((List)report.getDependencies().getOverwritten().get("widget"))).containsOnly(new Object[]{existingWidget});
    }

    @Test
    void should_include_added_and_overwritten_fragments_in_imported_dependencies() throws Exception {
        Fragment newFragment = FragmentBuilder.aFragment().withId("newOne").build();
        Fragment existingFragment = this.mockExistsInRepository(FragmentBuilder.aFragment().withId("existing").build());
        HashMap<FragmentDependencyImporter, List<Fragment>> dependencies = new HashMap<FragmentDependencyImporter, List<Fragment>>();
        dependencies.put(this.fragmentDependencyImporter, Arrays.asList(newFragment, existingFragment));
        ImportReport report = ImportReport.from((Identifiable)FragmentBuilder.aFragment().build(), dependencies);
        Assertions.assertThat((List)((List)report.getDependencies().getAdded().get("fragment"))).containsOnly(new Object[]{newFragment});
        Assertions.assertThat((List)((List)report.getDependencies().getOverwritten().get("fragment"))).containsOnly(new Object[]{existingFragment});
    }
}

