/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.common.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.controller.importer.AbstractArtifactImporter;
import org.bonitasoft.web.designer.controller.importer.Import;
import org.bonitasoft.web.designer.controller.importer.ImportStore;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ImportStoreTest {
    @Mock
    private AbstractArtifactImporter<?> artifactImporter;
    private ImportStore importStore;

    ImportStoreTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.importStore = new ImportStore();
    }

    @Test
    void should_store_import() throws Exception {
        Path importPath = Paths.get("import/path", new String[0]);
        Import storedImport = this.importStore.store(this.artifactImporter, importPath);
        Assertions.assertThat((String)storedImport.getUUID()).isNotNull();
        Assertions.assertThat((Object)storedImport.getImporter()).isEqualTo(this.artifactImporter);
        Assertions.assertThat((Path)storedImport.getPath()).isEqualTo((Object)importPath);
    }

    @Test
    void should_get_a_stored_import() throws Exception {
        Import expectedImport = this.importStore.store(this.artifactImporter, Paths.get("import/path", new String[0]));
        Import fetchedImport = this.importStore.get(expectedImport.getUUID());
        Assertions.assertThat((Object)expectedImport).isEqualTo((Object)fetchedImport);
    }

    @Test
    void should_throw_not_found_exception_while_getting_an_unknown_import() throws Exception {
        org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> this.importStore.get("unknown-import"));
    }

    @Test
    void should_remove_a_stored_import() throws Exception {
        Import addedReport = this.importStore.store(this.artifactImporter, Paths.get("import/path", new String[0]));
        this.importStore.remove(addedReport.getUUID());
        String uuid = addedReport.getUUID();
        org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> this.importStore.get(uuid));
    }

    @Test
    void should_delete_folder_while_removing_a_stored_import(@TempDir Path temporaryFolder) throws Exception {
        Path importFolder = Files.createDirectory(temporaryFolder.resolve("importFolder"), new FileAttribute[0]);
        Import addedReport = this.importStore.store(this.artifactImporter, importFolder);
        this.importStore.remove(addedReport.getUUID());
        Assertions.assertThat((Path)importFolder).doesNotExist();
    }

    @Test
    void should_fail_silently_while_removing_an_unexisting_import() throws Exception {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.importStore.remove("unexinting id"));
    }
}

