/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.i18n;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.ArtifactBuilderException;
import org.bonitasoft.web.designer.i18n.LanguagePackFactory;
import org.bonitasoft.web.designer.model.JacksonJsonHandler;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class LanguagePackTest {
    private LanguagePackFactory languagePackFactory;
    @TempDir
    Path tempDir;

    LanguagePackTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.languagePackFactory = new LanguagePackFactory((JsonHandler)new JacksonJsonHandler(new ObjectMapper()));
    }

    @Test
    void should_convert_translation_into_json() throws Exception {
        Path poFile = Files.createFile(this.tempDir.resolve("simple.po"), new FileAttribute[0]);
        Files.write(poFile, this.readResource("/i18n/simple.po"), new OpenOption[0]);
        Assertions.assertThat((String)new String(this.languagePackFactory.create(poFile.toFile()).toJson())).isEqualTo("{\"francais\":{\"A page\":\"Une page\"}}");
    }

    @Test
    void should_convert_plural_translations_into_json() throws Exception {
        Path poFile = Files.createFile(this.tempDir.resolve("plural.po"), new FileAttribute[0]);
        Files.write(poFile, this.readResource("/i18n/plural.po"), new OpenOption[0]);
        Assertions.assertThat((String)new String(this.languagePackFactory.create(poFile.toFile()).toJson())).isEqualTo("{\"francais\":{\"A page\":[\"Une page\",\"Des pages\"]}}");
    }

    @Test
    void should_throw_a_runtime_exception_if_the_po_file_does_not_contains_the_language() throws Exception {
        Path folder = Files.createDirectory(this.tempDir.resolve("i18n"), new FileAttribute[0]);
        Path poFile = Files.createFile(folder.resolve("plural.po"), new FileAttribute[0]);
        Files.write(poFile, new String(this.readResource("/i18n/simple.po")).replace("Language: francais", "").getBytes(), new OpenOption[0]);
        org.junit.jupiter.api.Assertions.assertThrows(ArtifactBuilderException.class, () -> new String(this.languagePackFactory.create(poFile.toFile()).toJson()));
    }

    private byte[] readResource(String path) throws Exception {
        return Files.readAllBytes(Paths.get(this.getClass().getResource(path).toURI()));
    }
}

