/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.migration.StyleUpdateInputRequiredLabelMigrationStep;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.page.Page;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class StyleUpdateInputRequiredLabelMigrationStepTest {
    @Mock
    private AssetService<Page> pageAssetService;
    @InjectMocks
    private StyleUpdateInputRequiredLabelMigrationStep step;

    StyleUpdateInputRequiredLabelMigrationStepTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.step = new StyleUpdateInputRequiredLabelMigrationStep(this.pageAssetService);
    }

    private Asset expectedAsset(String name) {
        return AssetBuilder.anAsset().withType(AssetType.CSS).withName(name).build();
    }

    @Test
    void should_migrate_style_asset_to_only_update_control_label_required_content_property() throws Exception {
        Asset style = AssetBuilder.anAsset().withType(AssetType.CSS).withName("style.css").build();
        String initContent = "/* Add a red star after required inputs */\n.control-label--required:after {\n  content: \"*\";\n  color: #C00;\n}\".ping .pong {\n\" +\n content: \"*\";\n\" +\n color: #C00;\n\" +\n \"}";
        Page page = PageBuilder.aPage().withDesignerVersion("1.11.30").withAsset(new Asset[]{style}).build();
        Mockito.when((Object)this.pageAssetService.getAssetContent((Assetable)page, style)).thenReturn((Object)initContent);
        String finalContent = "/* Add a red star after required inputs */\n.control-label--required:after {\n  content: \" *\";\n  color: #C00;\n}\".ping .pong {\n\" +\n content: \"*\";\n\" +\n color: #C00;\n\" +\n \"}";
        this.step.migrate(page);
        ((AssetService)Mockito.verify(this.pageAssetService)).save((Assetable)page, this.expectedAsset("style.css"), finalContent.getBytes());
    }
}

