/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.util.Collections;
import java.util.Optional;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.migration.Migration;
import org.bonitasoft.web.designer.migration.MigrationStep;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.service.FragmentMigrationApplyer;
import org.bonitasoft.web.designer.service.WidgetService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class FragmentMigrationApplyerTest {
    @Mock
    private WidgetService widgetService;

    FragmentMigrationApplyerTest() {
    }

    @Test
    void should_migrate_a_fragment() throws Exception {
        MigrationStep mockMigrationStep = (MigrationStep)Mockito.mock(MigrationStep.class);
        Migration migration = new Migration("2.0", new MigrationStep[]{mockMigrationStep});
        FragmentMigrationApplyer migrationApplyer = new FragmentMigrationApplyer(Collections.singletonList(migration), this.widgetService);
        Fragment fragment = FragmentBuilder.aFragment().withId("myFragment").withDesignerVersion("1.0.0").withPreviousDesignerVersion("1.0.0").build();
        Mockito.when((Object)mockMigrationStep.migrate((Object)fragment)).thenReturn(Optional.empty());
        migrationApplyer.migrate(fragment, false);
        Assertions.assertEquals((Object)"1.0.0", (Object)fragment.getPreviousArtifactVersion());
        Assertions.assertEquals((Object)"2.0", (Object)fragment.getArtifactVersion());
        ((WidgetService)Mockito.verify((Object)this.widgetService, (VerificationMode)Mockito.never())).migrateAllCustomWidgetUsedInPreviewable((Previewable)fragment);
    }

    @Test
    void should_migrate_a_fragment_with_new_model_version() throws Exception {
        MigrationStep mockMigrationStep = (MigrationStep)Mockito.mock(MigrationStep.class);
        Migration migration = new Migration("2.1", new MigrationStep[]{mockMigrationStep});
        FragmentMigrationApplyer migrationApplyer = new FragmentMigrationApplyer(Collections.singletonList(migration), this.widgetService);
        Fragment fragment = FragmentBuilder.aFragment().withId("myFragment").withModelVersion("2.0").withPreviousDesignerVersion("1.7.11").build();
        Mockito.when((Object)mockMigrationStep.migrate((Object)fragment)).thenReturn(Optional.empty());
        migrationApplyer.migrate(fragment, false);
        Assertions.assertEquals((Object)"2.0", (Object)fragment.getPreviousArtifactVersion());
        Assertions.assertEquals((Object)"2.1", (Object)fragment.getArtifactVersion());
        ((WidgetService)Mockito.verify((Object)this.widgetService, (VerificationMode)Mockito.never())).migrateAllCustomWidgetUsedInPreviewable((Previewable)fragment);
    }

    @Test
    void should_not_migrate_a_fragment_when_its_already_in_good_version() throws Exception {
        MigrationStep mockMigrationStep = (MigrationStep)Mockito.mock(MigrationStep.class);
        Migration migration = new Migration("2.0", new MigrationStep[]{(MigrationStep)Mockito.mock(MigrationStep.class)});
        FragmentMigrationApplyer migrationApplyer = new FragmentMigrationApplyer(Collections.singletonList(migration), this.widgetService);
        Fragment fragment = FragmentBuilder.aFragment().withId("myFragment").withModelVersion("2.0").withPreviousArtifactVersion("2.0").build();
        Mockito.lenient().when((Object)mockMigrationStep.migrate((Object)fragment)).thenReturn(Optional.empty());
        migrationApplyer.migrate(fragment, false);
        Assertions.assertEquals((Object)"2.0", (Object)fragment.getPreviousArtifactVersion());
        Assertions.assertEquals((Object)"2.0", (Object)fragment.getArtifactVersion());
        ((WidgetService)Mockito.verify((Object)this.widgetService, (VerificationMode)Mockito.never())).migrateAllCustomWidgetUsedInPreviewable((Previewable)fragment);
    }

    @Test
    void should_migrate_all_widgets_use_in_fragment_when_fragment_is_migrated() throws Exception {
        MigrationStep mockMigrationStep = (MigrationStep)Mockito.mock(MigrationStep.class);
        Migration migration = new Migration("2.0", new MigrationStep[]{mockMigrationStep});
        FragmentMigrationApplyer migrationApplyer = new FragmentMigrationApplyer(Collections.singletonList(migration), this.widgetService);
        Fragment fragment = FragmentBuilder.aFragment().withId("myFragment").withDesignerVersion("1.0.0").withPreviousDesignerVersion("1.0.0").build();
        Mockito.when((Object)mockMigrationStep.migrate((Object)fragment)).thenReturn(Optional.empty());
        migrationApplyer.migrate(fragment, true);
        Assertions.assertEquals((Object)"1.0.0", (Object)fragment.getPreviousArtifactVersion());
        Assertions.assertEquals((Object)"2.0", (Object)fragment.getArtifactVersion());
        ((WidgetService)Mockito.verify((Object)this.widgetService)).migrateAllCustomWidgetUsedInPreviewable((Previewable)fragment);
    }
}

