/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.migration.Migration;
import org.bonitasoft.web.designer.migration.MigrationStep;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.bonitasoft.web.designer.model.migrationReport.MigrationResult;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStatus;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.service.FragmentService;
import org.bonitasoft.web.designer.service.PageMigrationApplyer;
import org.bonitasoft.web.designer.service.WidgetService;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class PageMigrationApplyerTest {
    @Mock
    private WidgetService widgetService;
    @Mock
    private FragmentService fragmentService;

    PageMigrationApplyerTest() {
    }

    @Test
    void should_migrate_a_page() throws Exception {
        MigrationStep mockMigrationStep = (MigrationStep)Mockito.mock(MigrationStep.class);
        Migration migration = new Migration("2.0", new MigrationStep[]{mockMigrationStep});
        PageMigrationApplyer migrationApplyer = new PageMigrationApplyer(List.of(migration), this.widgetService, this.fragmentService);
        Page page = PageBuilder.aPage().withId("myPage").withDesignerVersion("1.0.1").withPreviousDesignerVersion("1.0.0").build();
        Mockito.when((Object)mockMigrationStep.migrate((Object)page)).thenReturn(Optional.of(new MigrationStepReport(MigrationStatus.SUCCESS, "myPage")));
        migrationApplyer.migrate(page);
        Assertions.assertThat((String)page.getArtifactVersion()).isEqualTo("2.0");
        Assertions.assertThat((String)page.getPreviousArtifactVersion()).isEqualTo("1.0.1");
    }

    @Test
    void should_migrate_a_page_with_new_model_version() throws Exception {
        MigrationStep mockMigrationStep = (MigrationStep)Mockito.mock(MigrationStep.class);
        Migration migration = new Migration("2.1", new MigrationStep[]{mockMigrationStep});
        PageMigrationApplyer migrationApplyer = new PageMigrationApplyer(Collections.singletonList(migration), this.widgetService, this.fragmentService);
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("2.0").withPreviousArtifactVersion("1.7.11").build();
        Mockito.when((Object)mockMigrationStep.migrate((Object)page)).thenReturn(Optional.of(new MigrationStepReport(MigrationStatus.SUCCESS, "myPage")));
        migrationApplyer.migrate(page);
        Assertions.assertThat((String)page.getPreviousArtifactVersion()).isEqualTo("2.0");
        Assertions.assertThat((String)page.getArtifactVersion()).isEqualTo("2.1");
    }

    @Test
    void should_not_modify_previous_model_version_when_no_migration_done() throws Exception {
        Migration migration = new Migration("2.0", new MigrationStep[]{(MigrationStep)Mockito.mock(MigrationStep.class)});
        PageMigrationApplyer migrationApplyer = new PageMigrationApplyer(Collections.singletonList(migration), this.widgetService, this.fragmentService);
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("2.0").withPreviousArtifactVersion("2.0").build();
        migrationApplyer.migrate(page);
        Assertions.assertThat((String)page.getPreviousArtifactVersion()).isEqualTo("2.0");
        Assertions.assertThat((String)page.getArtifactVersion()).isEqualTo("2.0");
    }

    @Test
    void should_migrate_all_custom_widget_uses_in_page_when_page_migration_is_done() throws Exception {
        MigrationStep mockMigrationStep = (MigrationStep)Mockito.mock(MigrationStep.class);
        Migration migration = new Migration("2.0", new MigrationStep[]{mockMigrationStep});
        PageMigrationApplyer migrationApplyer = new PageMigrationApplyer(Collections.singletonList(migration), this.widgetService, this.fragmentService);
        Page page = PageBuilder.aPage().withId("myPage").withDesignerVersion("1.0.0").withPreviousDesignerVersion("1.0.0").build();
        Mockito.when((Object)mockMigrationStep.migrate((Object)page)).thenReturn(Optional.of(new MigrationStepReport(MigrationStatus.SUCCESS, "myPage")));
        MigrationResult result = migrationApplyer.migrate(page);
        Page migratedPage = (Page)result.getArtifact();
        ((WidgetService)Mockito.verify((Object)this.widgetService)).migrateAllCustomWidgetUsedInPreviewable((Previewable)migratedPage);
        Assertions.assertThat((String)migratedPage.getPreviousArtifactVersion()).isEqualTo("1.0.0");
        Assertions.assertThat((String)migratedPage.getArtifactVersion()).isEqualTo("2.0");
    }

    @Test
    void should_migrate_a_page_and_generate_a_report_when_two_step_is_done_and_one_is_return_warning_status() throws Exception {
        MigrationStep mockMigrationStep = (MigrationStep)Mockito.mock(MigrationStep.class);
        MigrationStep mockMigrationStepWarning = (MigrationStep)Mockito.mock(MigrationStep.class);
        Migration migration = new Migration("2.0", new MigrationStep[]{mockMigrationStep, mockMigrationStepWarning});
        PageMigrationApplyer migrationApplyer = new PageMigrationApplyer(Collections.singletonList(migration), this.widgetService, this.fragmentService);
        Page page = PageBuilder.aPage().withId("myPage").withDesignerVersion("1.0.1").withPreviousDesignerVersion("1.0.0").build();
        Mockito.when((Object)mockMigrationStep.migrate((Object)page)).thenReturn(Optional.empty());
        Mockito.when((Object)mockMigrationStepWarning.migrate((Object)page)).thenReturn(Optional.of(new MigrationStepReport(MigrationStatus.WARNING, "myPage", "You can remove xxx assets if you don't use it")));
        MigrationResult result = migrationApplyer.migrate(page);
        Page migratedPage = (Page)result.getArtifact();
        Assertions.assertThat((Comparable)result.getFinalStatus()).isEqualTo((Object)MigrationStatus.WARNING);
        Assertions.assertThat((List)result.getMigrationStepReportList()).hasSize(2);
        Assertions.assertThat((List)result.getMigrationStepReportListFilterByFinalStatus()).hasSize(1);
        Assertions.assertThat((Comparable)((MigrationStepReport)result.getMigrationStepReportListFilterByFinalStatus().get(0)).getMigrationStatus()).isEqualTo((Object)MigrationStatus.WARNING);
        Assertions.assertThat((String)migratedPage.getPreviousArtifactVersion()).isEqualTo("1.0.1");
        Assertions.assertThat((String)migratedPage.getArtifactVersion()).isEqualTo("2.0");
    }

    @Test
    void should_return_an_report_with_error_when_error_occurs_during_migration_page() throws Exception {
        MigrationStep mockMigrationStep = (MigrationStep)Mockito.mock(MigrationStep.class);
        Migration migration = new Migration("2.0", new MigrationStep[]{mockMigrationStep});
        PageMigrationApplyer migrationApplyer = new PageMigrationApplyer(Collections.singletonList(migration), this.widgetService, this.fragmentService);
        Page page = PageBuilder.aPage().withId("myPage").withDesignerVersion("1.0.1").withPreviousDesignerVersion("1.0.0").build();
        Mockito.when((Object)mockMigrationStep.migrate((Object)page)).thenThrow(new Throwable[]{new Exception()});
        MigrationResult result = migrationApplyer.migrate(page);
        Page migratedPage = (Page)result.getArtifact();
        Assertions.assertThat((String)migratedPage.getPreviousArtifactVersion()).isEqualTo("1.0.1");
        Assertions.assertThat((String)migratedPage.getArtifactVersion()).isEqualTo("2.0");
        MigrationStepReport report = (MigrationStepReport)result.getMigrationStepReportList().get(0);
        Assertions.assertThat((Comparable)report.getMigrationStatus()).isEqualTo((Object)MigrationStatus.ERROR);
        Assertions.assertThat((String)report.getArtifactId()).isEqualTo("myPage");
    }

    @Test
    void should_migrate_widgets_and_fragment_when_parent_page_are_migrated() throws Exception {
        MigrationStep mockMigrationStep = (MigrationStep)Mockito.mock(MigrationStep.class);
        Migration migration = new Migration("2.0", new MigrationStep[]{mockMigrationStep});
        PageMigrationApplyer migrationApplyer = new PageMigrationApplyer(Collections.singletonList(migration), this.widgetService, this.fragmentService);
        Page page = PageBuilder.aPage().withPreviousArtifactVersion("1.0.0").withDesignerVersion("1.0.0").build();
        Mockito.when((Object)mockMigrationStep.migrate((Object)page)).thenReturn(Optional.empty());
        migrationApplyer.migrate(page);
        ((FragmentService)Mockito.verify((Object)this.fragmentService)).migrateAllFragmentUsed((Previewable)page);
        ((WidgetService)Mockito.verify((Object)this.widgetService)).migrateAllCustomWidgetUsedInPreviewable((Previewable)page);
        Assertions.assertThat((String)page.getPreviousArtifactVersion()).isEqualTo("1.0.0");
        Assertions.assertThat((String)page.getArtifactVersion()).isEqualTo("2.0");
    }

    @Test
    void should_get_correct_migration_status_when_one_dependency_is_to_migrate() throws Exception {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("2.0").build();
        Mockito.when((Object)this.widgetService.getArtifactStatusOfCustomWidgetUsed((Previewable)page)).thenReturn((Object)new ArtifactStatusReport(true, true));
        Mockito.when((Object)this.fragmentService.getArtifactStatusOfFragmentUsed((Previewable)page)).thenReturn((Object)new ArtifactStatusReport(true, false));
        PageMigrationApplyer migrationApplyer = new PageMigrationApplyer(Collections.singletonList(null), this.widgetService, this.fragmentService);
        ArtifactStatusReport status = migrationApplyer.getPageStatusDependencies(page);
        Assertions.assertThat((String)this.getArtifactStatusReport(true, true)).isEqualTo(status.toString());
    }

    @Test
    void should_get_correct_migration_status_when_one_dependency_is_incompatible() throws Exception {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("2.0").build();
        Mockito.when((Object)this.widgetService.getArtifactStatusOfCustomWidgetUsed((Previewable)page)).thenReturn((Object)new ArtifactStatusReport(false, false));
        Mockito.when((Object)this.fragmentService.getArtifactStatusOfFragmentUsed((Previewable)page)).thenReturn((Object)new ArtifactStatusReport(true, true));
        PageMigrationApplyer migrationApplyer = new PageMigrationApplyer(Collections.singletonList(null), this.widgetService, this.fragmentService);
        ArtifactStatusReport status = migrationApplyer.getPageStatusDependencies(page);
        Assertions.assertThat((String)this.getArtifactStatusReport(false, false)).isEqualTo(status.toString());
    }

    @Test
    void should_get_correct_migration_status_when_dependencies_are_correct() throws Exception {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("2.0").build();
        Mockito.when((Object)this.widgetService.getArtifactStatusOfCustomWidgetUsed((Previewable)page)).thenReturn((Object)new ArtifactStatusReport(true, false));
        Mockito.when((Object)this.fragmentService.getArtifactStatusOfFragmentUsed((Previewable)page)).thenReturn((Object)new ArtifactStatusReport(true, false));
        PageMigrationApplyer migrationApplyer = new PageMigrationApplyer(Collections.singletonList(null), this.widgetService, this.fragmentService);
        ArtifactStatusReport status = migrationApplyer.getPageStatusDependencies(page);
        Assertions.assertThat((String)this.getArtifactStatusReport(true, false)).isEqualTo(status.toString());
    }

    private String getArtifactStatusReport(boolean compatible, boolean migration) {
        return new ArtifactStatusReport(compatible, migration).toString();
    }
}

