/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.bonitasoft.web.angularjs.GeneratorProperties;
import org.bonitasoft.web.designer.ArtifactBuilder;
import org.bonitasoft.web.designer.ArtifactBuilderFactory;
import org.bonitasoft.web.designer.UiDesignerCore;
import org.bonitasoft.web.designer.UiDesignerCoreFactory;
import org.bonitasoft.web.designer.Version;
import org.bonitasoft.web.designer.builder.UiDesignerPropertiesTestBuilder;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonHandlerFactory;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.model.widget.BondType;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.service.PageService;
import org.bonitasoft.web.designer.service.WidgetService;
import org.bonitasoft.web.designer.workspace.Workspace;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class WorkspaceMigrationTest {
    private static final String HIGHER_MIGRATION_VERSION = Version.MODEL_VERSION;
    private static PageService pageService;
    private static WidgetService widgetService;
    private static Workspace workspace;

    WorkspaceMigrationTest() {
    }

    @BeforeAll
    public static void setUp(@TempDir Path tempdir) throws Exception {
        Path workspacePath = Paths.get(WorkspaceMigrationTest.class.getClassLoader().getResource("workspace").toURI());
        UiDesignerProperties uiDesignerProperties = UiDesignerPropertiesTestBuilder.aUiDesignerProperties(workspacePath);
        uiDesignerProperties.setModelVersion(HIGHER_MIGRATION_VERSION);
        uiDesignerProperties.setVersion("1.13.0-SNAPSHOT");
        uiDesignerProperties.setEdition("Community");
        uiDesignerProperties.getWorkspaceUid().setPath(tempdir);
        Path assetCss = Files.createDirectories(uiDesignerProperties.getWorkspaceUid().getExtractPath().resolve("angularjs/templates/page/assets/css"), new FileAttribute[0]);
        Files.createFile(assetCss.resolve("style.css"), new FileAttribute[0]);
        JsonHandler jsonHandler = new JsonHandlerFactory().create();
        GeneratorProperties generatorProperties = new GeneratorProperties(tempdir);
        UiDesignerCore core = new UiDesignerCoreFactory(uiDesignerProperties, generatorProperties, jsonHandler).create();
        ArtifactBuilder artifactBuilder = new ArtifactBuilderFactory(uiDesignerProperties, generatorProperties, jsonHandler, core).create();
        workspace = artifactBuilder.getWorkspace();
        workspace.initialize();
        widgetService = core.getWidgetService();
        pageService = core.getPageService();
    }

    @Test
    void should_migrate_a_page() {
        workspace.migrateWorkspace();
        Page page = (Page)pageService.get("page_1_0_0");
        Assertions.assertThat((String)page.getArtifactVersion()).isEqualTo(HIGHER_MIGRATION_VERSION);
        Assertions.assertThat((String)page.getPreviousArtifactVersion()).isEqualTo("1.0.0");
        Assertions.assertThat(page.getAssets().stream().map(Asset::getId)).doesNotContainNull();
    }

    @Test
    void should_migrate_a_page_property_values() {
        workspace.migrateWorkspace();
        Page page = (Page)pageService.get("page_1_0_1");
        Map propertyValues = ((Element)page.getRows().stream().flatMap(Collection::stream).iterator().next()).getPropertyValues();
        Assertions.assertThat(propertyValues.values().stream().map(PropertyValue::getType)).doesNotContain((Object[])new String[]{"data"});
    }

    @Test
    void should_migrate_a_page_adding_text_widget_interpret_HTML_property_value() {
        workspace.migrateWorkspace();
        Page page = (Page)pageService.get("page_1_5_51");
        Assertions.assertThat((String)page.getArtifactVersion()).isEqualTo(HIGHER_MIGRATION_VERSION);
        Map propertyValues = ((Element)page.getRows().stream().flatMap(Collection::stream).iterator().next()).getPropertyValues();
        PropertyValue allowHTMLProperty = (PropertyValue)propertyValues.get("allowHTML");
        Assertions.assertThat((Object)allowHTMLProperty).isNotNull();
        Assertions.assertThat((String)allowHTMLProperty.getType()).isEqualTo(BondType.CONSTANT.toJson());
        Assertions.assertThat((Object)allowHTMLProperty.getValue()).isEqualTo((Object)Boolean.TRUE);
    }

    @Test
    void should_migrate_a_custom_widget() throws IOException {
        workspace.migrateWorkspace();
        Widget widget = widgetService.get("widget_1_0_0");
        Assertions.assertThat((String)widget.getArtifactVersion()).isEqualTo(HIGHER_MIGRATION_VERSION);
        Assertions.assertThat((String)widget.getPreviousArtifactVersion()).isEqualTo("1.0.0");
        Assertions.assertThat(widget.getAssets().stream().map(Asset::getId)).doesNotContainNull();
    }

    @Test
    void should_migrate_a_page_adding_uiBootstrap() {
        workspace.migrateWorkspace();
        Page page = (Page)pageService.get("page_1_0_1");
        Assertions.assertThat(page.getAssets().stream().map(Asset::getName)).contains((Object[])new String[]{"ui-bootstrap-tpls-0.13.0.min.js"});
    }

    @Test
    void should_migrate_a_page_not_adding_uiBootstrap_when_already_a_page_asset() {
        workspace.migrateWorkspace();
        Page page = (Page)pageService.get("pageWithUIBootstrap");
        Assertions.assertThat((String)page.getArtifactVersion()).isEqualTo(HIGHER_MIGRATION_VERSION);
        Assertions.assertThat((String)page.getPreviousArtifactVersion()).isEqualTo("1.0.1");
        ((ListAssert)Assertions.assertThat(page.getAssets().stream().map(Asset::getName)).doesNotContain((Object[])new String[]{"ui-bootstrap-tpls-0.13.0.min.js"})).hasSize(2);
    }

    @Test
    void should_migrate_a_page_not_adding_uiBootstrap_when_already_a_widget_asset() {
        workspace.migrateWorkspace();
        Page page = (Page)pageService.get("pageWithUIBootstrapWidget");
        Assertions.assertThat((String)page.getArtifactVersion()).isEqualTo(HIGHER_MIGRATION_VERSION);
        Assertions.assertThat((String)page.getPreviousArtifactVersion()).isEqualTo("1.0.1");
        ((ListAssert)Assertions.assertThat(page.getAssets().stream().map(Asset::getName)).doesNotContain((Object[])new String[]{"ui-bootstrap-tpls-0.13.0.min.js"})).hasSize(1);
    }
}

