/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bonitasoft.web.designer.ArtifactBuilder;
import org.bonitasoft.web.designer.common.generator.rendering.GenerationException;
import org.bonitasoft.web.designer.common.generator.rendering.HtmlGenerator;
import org.bonitasoft.web.designer.controller.export.ExportException;
import org.bonitasoft.web.designer.controller.export.FragmentExporter;
import org.bonitasoft.web.designer.controller.export.PageExporter;
import org.bonitasoft.web.designer.controller.export.WidgetExporter;
import org.bonitasoft.web.designer.controller.importer.AbstractArtifactImporter;
import org.bonitasoft.web.designer.controller.importer.FragmentImporter;
import org.bonitasoft.web.designer.controller.importer.Import;
import org.bonitasoft.web.designer.controller.importer.ImportException;
import org.bonitasoft.web.designer.controller.importer.ImportPathResolver;
import org.bonitasoft.web.designer.controller.importer.ImportStore;
import org.bonitasoft.web.designer.controller.importer.PageImporter;
import org.bonitasoft.web.designer.controller.importer.WidgetImporter;
import org.bonitasoft.web.designer.controller.importer.report.ImportReport;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.bonitasoft.web.designer.model.ModelException;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.service.FragmentService;
import org.bonitasoft.web.designer.service.PageService;
import org.bonitasoft.web.designer.service.WidgetService;
import org.bonitasoft.web.designer.workspace.Workspace;

public class DefaultArtifactBuilder
implements ArtifactBuilder {
    public static final List<String> supportedArtifactTypes = List.of("page", "fragment", "widget");
    private final Workspace workspace;
    private final WidgetService widgetService;
    private final FragmentService fragmentService;
    private final PageService pageService;
    private final PageExporter pageExporter;
    private final FragmentExporter fragmentExporter;
    private final WidgetExporter widgetExporter;
    private final HtmlGenerator htmlGenerator;
    private final ImportStore importStore;
    private final PageImporter pageImporter;
    private final FragmentImporter fragmentImporter;
    private final WidgetImporter widgetImporter;

    @Override
    public byte[] buildPage(String id) throws ModelException, ExportException, IOException {
        return this.build((Page)this.pageService.get(id));
    }

    @Override
    public byte[] build(Page page) throws ModelException, ExportException, IOException {
        ByteArrayOutputStream outputStream;
        try (ByteArrayOutputStream byteArrayOutputStream = outputStream = new ByteArrayOutputStream();){
            this.pageExporter.handleFileExport(page.getId(), outputStream);
        }
        return outputStream.toByteArray();
    }

    @Override
    public byte[] buildFragment(String id) throws ModelException, ExportException, IOException {
        return this.build((Fragment)this.fragmentService.get(id));
    }

    @Override
    public byte[] build(Fragment fragment) throws ModelException, ExportException, IOException {
        ByteArrayOutputStream outputStream;
        try (ByteArrayOutputStream byteArrayOutputStream = outputStream = new ByteArrayOutputStream();){
            this.fragmentExporter.handleFileExport(fragment.getId(), outputStream);
        }
        return outputStream.toByteArray();
    }

    @Override
    public byte[] buildWidget(String id) throws ModelException, ExportException, IOException {
        return this.build(this.widgetService.get(id));
    }

    @Override
    public byte[] build(Widget widget) throws ModelException, ExportException, IOException {
        ByteArrayOutputStream outputStream;
        try (ByteArrayOutputStream byteArrayOutputStream = outputStream = new ByteArrayOutputStream();){
            this.widgetExporter.handleFileExport(widget.getId(), outputStream);
        }
        return outputStream.toByteArray();
    }

    @Override
    public String buildHtml(Page page, String context) throws GenerationException {
        return this.htmlGenerator.generateHtml((Previewable)page, context);
    }

    @Override
    public String buildHtml(Fragment fragment, String context) throws GenerationException {
        return this.htmlGenerator.generateHtml((Previewable)fragment, context);
    }

    @Override
    public ImportReport importArtifact(Path path, boolean ignoreConflicts) {
        Path zipFiles = ImportPathResolver.resolveImportPath(path);
        String artifactType = this.resolveArtifactType(zipFiles);
        ImportReport report = null;
        switch (artifactType) {
            case "page": {
                report = this.importPage(path, ignoreConflicts);
                break;
            }
            case "fragment": {
                report = this.importFragment(path, ignoreConflicts);
                break;
            }
            case "widget": {
                report = this.importWidget(path, ignoreConflicts);
                break;
            }
            default: {
                throw new ImportException(ImportException.Type.MODEL_NOT_FOUND, "Unknown artifact type: " + artifactType);
            }
        }
        return report;
    }

    protected String resolveArtifactType(Path zipFiles) {
        return supportedArtifactTypes.stream().filter(type -> Files.exists(zipFiles.resolve(type + ".json"), new LinkOption[0])).findFirst().orElseThrow(() -> {
            ImportException importException = new ImportException(ImportException.Type.MODEL_NOT_FOUND, "Could not load component, artifact model file not found");
            importException.addInfo("modelfiles", supportedArtifactTypes.stream().map(type -> type + ".json").collect(Collectors.toList()));
            return importException;
        });
    }

    @Override
    public ImportReport importPage(Path path, boolean ignoreConflicts) {
        return this.importFromPath(path, ignoreConflicts, this.pageImporter);
    }

    @Override
    public ImportReport importFragment(Path path, boolean ignoreConflicts) {
        return this.importFromPath(path, ignoreConflicts, this.fragmentImporter);
    }

    @Override
    public ImportReport importWidget(Path path, boolean ignoreConflicts) {
        return this.importFromPath(path, ignoreConflicts, this.widgetImporter);
    }

    @Override
    public ImportReport replayImportIgnoringConflicts(String uuid) {
        Import anImport = this.importStore.get(uuid);
        return anImport.getImporter().tryToImportAndGenerateReport(anImport, true);
    }

    @Override
    public void cancelImport(String uuid) {
        this.importStore.remove(uuid);
    }

    @Override
    public ArtifactStatusReport getPageStatus(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return ((Page)this.pageService.get(id)).getStatus();
    }

    @Override
    public ArtifactStatusReport getPageStatus(@NonNull Page page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        return this.pageService.getStatus(page);
    }

    @Override
    public ArtifactStatusReport getFragmentStatus(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return ((Fragment)this.fragmentService.get(id)).getStatus();
    }

    @Override
    public ArtifactStatusReport getFragmentStatus(@NonNull Fragment fragment) {
        if (fragment == null) {
            throw new NullPointerException("fragment is marked non-null but is null");
        }
        return this.fragmentService.getStatus(fragment);
    }

    @Override
    public ArtifactStatusReport getWidgetStatus(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.widgetService.get(id).getStatus();
    }

    @Override
    public ArtifactStatusReport getWidgetStatus(@NonNull Widget widget) {
        if (widget == null) {
            throw new NullPointerException("widget is marked non-null but is null");
        }
        return this.widgetService.getStatus(widget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImportReport importFromPath(Path path, boolean ignoreConflicts, AbstractArtifactImporter<?> importer) {
        Import anImport = this.importStore.store(importer, path);
        ImportReport report = null;
        try {
            report = importer.tryToImportAndGenerateReport(anImport, ignoreConflicts);
        }
        finally {
            if (report == null || ImportReport.Status.IMPORTED.equals((Object)report.getStatus())) {
                this.importStore.remove(anImport.getUUID());
            }
        }
        return report;
    }

    public DefaultArtifactBuilder(Workspace workspace, WidgetService widgetService, FragmentService fragmentService, PageService pageService, PageExporter pageExporter, FragmentExporter fragmentExporter, WidgetExporter widgetExporter, HtmlGenerator htmlGenerator, ImportStore importStore, PageImporter pageImporter, FragmentImporter fragmentImporter, WidgetImporter widgetImporter) {
        this.workspace = workspace;
        this.widgetService = widgetService;
        this.fragmentService = fragmentService;
        this.pageService = pageService;
        this.pageExporter = pageExporter;
        this.fragmentExporter = fragmentExporter;
        this.widgetExporter = widgetExporter;
        this.htmlGenerator = htmlGenerator;
        this.importStore = importStore;
        this.pageImporter = pageImporter;
        this.fragmentImporter = fragmentImporter;
        this.widgetImporter = widgetImporter;
    }

    @Override
    public Workspace getWorkspace() {
        return this.workspace;
    }
}

