/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.config;

import org.bonitasoft.web.designer.config.WorkspaceProperties;
import org.bonitasoft.web.designer.config.WorkspaceUidProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="designer")
public class UiDesignerProperties {
    public static final String BONITA_BDM_URL = "designer.bonita.bdm.url";
    public static final String BONITA_PORTAL_URL = "designer.bonita.portal.url";
    public static final String BONITA_PORTAL_USER = "designer.bonita.portal.user";
    public static final String BONITA_PORTAL_PASSWORD = "designer.bonita.portal.password";
    private String edition;
    private String version;
    private String modelVersion;
    private boolean experimental;
    private BonitaProperties bonita = new BonitaProperties();
    private WorkspaceProperties workspace = new WorkspaceProperties();
    private WorkspaceUidProperties workspaceUid = new WorkspaceUidProperties();

    public UiDesignerProperties(String version, String modelVersion) {
        this.version = version;
        this.modelVersion = modelVersion;
    }

    public String getEdition() {
        return this.edition;
    }

    public String getVersion() {
        return this.version;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public boolean isExperimental() {
        return this.experimental;
    }

    public BonitaProperties getBonita() {
        return this.bonita;
    }

    public WorkspaceProperties getWorkspace() {
        return this.workspace;
    }

    public WorkspaceUidProperties getWorkspaceUid() {
        return this.workspaceUid;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public void setExperimental(boolean experimental) {
        this.experimental = experimental;
    }

    public void setBonita(BonitaProperties bonita) {
        this.bonita = bonita;
    }

    public void setWorkspace(WorkspaceProperties workspace) {
        this.workspace = workspace;
    }

    public void setWorkspaceUid(WorkspaceUidProperties workspaceUid) {
        this.workspaceUid = workspaceUid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UiDesignerProperties)) {
            return false;
        }
        UiDesignerProperties other = (UiDesignerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isExperimental() != other.isExperimental()) {
            return false;
        }
        String this$edition = this.getEdition();
        String other$edition = other.getEdition();
        if (this$edition == null ? other$edition != null : !this$edition.equals(other$edition)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$modelVersion = this.getModelVersion();
        String other$modelVersion = other.getModelVersion();
        if (this$modelVersion == null ? other$modelVersion != null : !this$modelVersion.equals(other$modelVersion)) {
            return false;
        }
        BonitaProperties this$bonita = this.getBonita();
        BonitaProperties other$bonita = other.getBonita();
        if (this$bonita == null ? other$bonita != null : !((Object)this$bonita).equals(other$bonita)) {
            return false;
        }
        WorkspaceProperties this$workspace = this.getWorkspace();
        WorkspaceProperties other$workspace = other.getWorkspace();
        if (this$workspace == null ? other$workspace != null : !((Object)this$workspace).equals(other$workspace)) {
            return false;
        }
        WorkspaceUidProperties this$workspaceUid = this.getWorkspaceUid();
        WorkspaceUidProperties other$workspaceUid = other.getWorkspaceUid();
        return !(this$workspaceUid == null ? other$workspaceUid != null : !((Object)this$workspaceUid).equals(other$workspaceUid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UiDesignerProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isExperimental() ? 79 : 97);
        String $edition = this.getEdition();
        result = result * 59 + ($edition == null ? 43 : $edition.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $modelVersion = this.getModelVersion();
        result = result * 59 + ($modelVersion == null ? 43 : $modelVersion.hashCode());
        BonitaProperties $bonita = this.getBonita();
        result = result * 59 + ($bonita == null ? 43 : ((Object)$bonita).hashCode());
        WorkspaceProperties $workspace = this.getWorkspace();
        result = result * 59 + ($workspace == null ? 43 : ((Object)$workspace).hashCode());
        WorkspaceUidProperties $workspaceUid = this.getWorkspaceUid();
        result = result * 59 + ($workspaceUid == null ? 43 : ((Object)$workspaceUid).hashCode());
        return result;
    }

    public String toString() {
        return "UiDesignerProperties(edition=" + this.getEdition() + ", version=" + this.getVersion() + ", modelVersion=" + this.getModelVersion() + ", experimental=" + this.isExperimental() + ", bonita=" + this.getBonita() + ", workspace=" + this.getWorkspace() + ", workspaceUid=" + this.getWorkspaceUid() + ")";
    }

    public UiDesignerProperties() {
    }

    public static class BdmProperties {
        private String url;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BdmProperties)) {
                return false;
            }
            BdmProperties other = (BdmProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BdmProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        public String toString() {
            return "UiDesignerProperties.BdmProperties(url=" + this.getUrl() + ")";
        }
    }

    public static class PortalProperties {
        private String url;
        private String user;
        private String password;

        public String getUrl() {
            return this.url;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PortalProperties)) {
                return false;
            }
            PortalProperties other = (PortalProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PortalProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "UiDesignerProperties.PortalProperties(url=" + this.getUrl() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ")";
        }
    }

    public static class BonitaProperties {
        private PortalProperties portal = new PortalProperties();
        private BdmProperties bdm = new BdmProperties();

        public PortalProperties getPortal() {
            return this.portal;
        }

        public BdmProperties getBdm() {
            return this.bdm;
        }

        public void setPortal(PortalProperties portal) {
            this.portal = portal;
        }

        public void setBdm(BdmProperties bdm) {
            this.bdm = bdm;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BonitaProperties)) {
                return false;
            }
            BonitaProperties other = (BonitaProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PortalProperties this$portal = this.getPortal();
            PortalProperties other$portal = other.getPortal();
            if (this$portal == null ? other$portal != null : !((Object)this$portal).equals(other$portal)) {
                return false;
            }
            BdmProperties this$bdm = this.getBdm();
            BdmProperties other$bdm = other.getBdm();
            return !(this$bdm == null ? other$bdm != null : !((Object)this$bdm).equals(other$bdm));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BonitaProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PortalProperties $portal = this.getPortal();
            result = result * 59 + ($portal == null ? 43 : ((Object)$portal).hashCode());
            BdmProperties $bdm = this.getBdm();
            result = result * 59 + ($bdm == null ? 43 : ((Object)$bdm).hashCode());
            return result;
        }

        public String toString() {
            return "UiDesignerProperties.BonitaProperties(portal=" + this.getPortal() + ", bdm=" + this.getBdm() + ")";
        }
    }
}

