/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.steps;

import java.io.IOException;
import org.bonitasoft.web.designer.common.export.ExportStep;
import org.bonitasoft.web.designer.common.export.Zipper;
import org.bonitasoft.web.designer.common.repository.AssetRepository;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.page.Page;

public class AssetExportStep
implements ExportStep<Page> {
    private final AssetRepository<Page> pageAssetRepository;

    public AssetExportStep(AssetRepository<Page> pageAssetRepository) {
        this.pageAssetRepository = pageAssetRepository;
    }

    public void execute(Zipper zipper, Page page) throws IOException {
        for (Asset pageAsset : page.getAssets()) {
            if (pageAsset.isExternal()) continue;
            zipper.addDirectoryToZip(this.pageAssetRepository.findAssetPath(page.getId(), pageAsset.getName(), pageAsset.getType()), Zipper.ALL_DIRECTORIES, Zipper.ALL_FILES, String.format("%s/assets/%s/%s", "resources", pageAsset.getType().getPrefix(), pageAsset.getName()));
        }
    }
}

