/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import java.util.Optional;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.model.widget.BondType;
import org.bonitasoft.web.designer.visitor.ComponentVisitor;
import org.bonitasoft.web.designer.visitor.ElementVisitor;

public class TextWidgetInterpretHTMLMigrationStep<T extends AbstractPage>
extends AbstractMigrationStep<T> {
    private ComponentVisitor componentVisitor;

    public TextWidgetInterpretHTMLMigrationStep(ComponentVisitor componentVisitor) {
        this.componentVisitor = componentVisitor;
    }

    @Override
    public Optional<MigrationStepReport> migrate(AbstractPage page) {
        for (Component component : (Iterable)page.accept((ElementVisitor)this.componentVisitor)) {
            if (!"pbText".equals(component.getId()) || component.getPropertyValues().containsKey("allowHTML")) continue;
            PropertyValue interpretHTMLValue = new PropertyValue();
            interpretHTMLValue.setType(BondType.CONSTANT.toJson());
            interpretHTMLValue.setValue((Object)Boolean.TRUE);
            component.getPropertyValues().put("allowHTML", interpretHTMLValue);
        }
        return Optional.empty();
    }
}

