/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.util.List;
import org.bonitasoft.web.designer.common.repository.Repository;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.widget.Property;
import org.bonitasoft.web.designer.visitor.FixBondsTypesVisitor;

public class BondsTypesFixer<T extends Identifiable & Previewable> {
    private final Repository<T> repository;

    public BondsTypesFixer(Repository<T> repository) {
        this.repository = repository;
    }

    public void fixBondsTypes(String widgetId, List<Property> properties) {
        List artifactsUsingWidget = this.repository.findByObjectId(widgetId);
        FixBondsTypesVisitor fixBondsTypesVisitor = new FixBondsTypesVisitor(properties);
        for (Identifiable artifactUsingWidget : artifactsUsingWidget) {
            fixBondsTypesVisitor.visit((Previewable)artifactUsingWidget);
            this.repository.save(artifactUsingWidget);
        }
    }
}

