/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import java.util.Collection;
import java.util.List;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.ModalContainer;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;
import org.bonitasoft.web.designer.model.widget.BondType;
import org.bonitasoft.web.designer.model.widget.Property;
import org.bonitasoft.web.designer.visitor.ElementVisitor;

public class FixBondsTypesVisitor
implements ElementVisitor<Void> {
    private final List<Property> properties;

    public FixBondsTypesVisitor(List<Property> properties) {
        this.properties = properties;
    }

    public Void visit(Container container) {
        container.getRows().stream().flatMap(Collection::stream).forEach(element -> element.accept((ElementVisitor)this));
        return null;
    }

    public Void visit(FormContainer formContainer) {
        this.visit(formContainer.getContainer());
        return null;
    }

    public Void visit(TabsContainer tabsContainer) {
        for (TabContainer tab : tabsContainer.getTabList()) {
            this.visit(tab);
        }
        return null;
    }

    public Void visit(ModalContainer modalContainer) {
        this.visit(modalContainer.getContainer());
        return null;
    }

    public Void visit(TabContainer tabContainer) {
        this.visit(tabContainer.getContainer());
        return null;
    }

    public Void visit(Component component) {
        for (Property property : this.properties) {
            BondType bondType = property.getBond();
            PropertyValue propertyValue = (PropertyValue)component.getPropertyValues().get(property.getName());
            if (propertyValue == null) continue;
            if (BondType.EXPRESSION.equals((Object)bondType)) {
                bondType = BondType.CONSTANT;
            }
            propertyValue.setType(bondType.toJson());
        }
        return null;
    }

    public Void visit(FragmentElement fragmentElement) {
        return null;
    }

    public Void visit(Previewable previewable) {
        previewable.getRows().stream().flatMap(Collection::stream).forEach(element -> element.accept((ElementVisitor)this));
        return null;
    }
}

