/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer.dependencies;

import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.controller.importer.dependencies.WidgetDependencyImporter;
import org.bonitasoft.web.designer.model.Identifiable;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class WidgetDependencyImporterTest {
    @Mock
    private WidgetRepository widgetRepository;
    @InjectMocks
    private WidgetDependencyImporter widgetDependencyImporter;

    WidgetDependencyImporterTest() {
    }

    @Test
    void should_verify_that_a_widget_exists_in_repository() throws Exception {
        Mockito.when((Object)this.widgetRepository.exists("existingWidget")).thenReturn((Object)true);
        boolean exists = this.widgetDependencyImporter.exists((Identifiable)WidgetBuilder.aWidget().withId("existingWidget").build());
        Assertions.assertThat((boolean)exists).isTrue();
    }

    @Test
    void should_verify_that_a_widget_does_not_exists_in_repository() throws Exception {
        Mockito.when((Object)this.widgetRepository.exists("unknownWidget")).thenReturn((Object)false);
        boolean exists = this.widgetDependencyImporter.exists((Identifiable)WidgetBuilder.aWidget().withId("unknownWidget").build());
        Assertions.assertThat((boolean)exists).isFalse();
    }

    @Test
    void should_load_custom_widgets(@TempDir Path temporaryFolder) throws Exception {
        Path widgetsFolder = Files.createDirectory(temporaryFolder.resolve("widgets"), new FileAttribute[0]);
        this.widgetDependencyImporter.load(null, temporaryFolder);
        ArgumentCaptor captor = ArgumentCaptor.forClass(DirectoryStream.Filter.class);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).loadAll((Path)ArgumentMatchers.eq((Object)widgetsFolder), (DirectoryStream.Filter)captor.capture());
        Assertions.assertThat((Object)((DirectoryStream.Filter)captor.getValue())).isEqualTo((Object)WidgetRepository.CUSTOM_WIDGET_FILTER);
    }
}

