/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.i18n;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.angularjs.GeneratorProperties;
import org.bonitasoft.web.designer.common.livebuild.PathListener;
import org.bonitasoft.web.designer.common.livebuild.Watcher;
import org.bonitasoft.web.designer.i18n.LanguagePackBuilder;
import org.bonitasoft.web.designer.i18n.LanguagePackFactory;
import org.bonitasoft.web.designer.model.JacksonJsonHandler;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class LanguagePackBuilderTest {
    @Mock
    private Watcher watcher;
    private LanguagePackBuilder builder;
    private GeneratorProperties generatorProperties;
    @TempDir
    Path tempDir;

    LanguagePackBuilderTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.newLanguagePackBuilder(true);
    }

    private void newLanguagePackBuilder(boolean liveBuildEnabled) {
        this.generatorProperties = new GeneratorProperties(this.tempDir);
        this.generatorProperties.setLiveBuildEnabled(liveBuildEnabled);
        this.builder = new LanguagePackBuilder(this.watcher, new LanguagePackFactory((JsonHandler)new JacksonJsonHandler(new ObjectMapper())), this.generatorProperties);
    }

    @Test
    void should_build_all_language_pack_under_provided_directory() throws Exception {
        Path frFile = Files.createFile(this.tempDir.resolve("fr.po"), new FileAttribute[0]);
        Path appClassPath = Files.createDirectory(this.tempDir.resolve("appClassPath"), new FileAttribute[0]);
        Path enFile = Files.createFile(appClassPath.resolve("en.po"), new FileAttribute[0]);
        Files.write(frFile, this.aSimplePoFile(), new OpenOption[0]);
        Files.write(enFile, this.aSimplePoFile(), new OpenOption[0]);
        this.builder.start(this.tempDir);
        Assertions.assertThat((Path)this.generatorProperties.getTmpI18nPath().resolve("fr.json")).exists();
        Assertions.assertThat((File)this.resolveJson(frFile)).exists();
        Assertions.assertThat((File)this.resolveJson(enFile)).exists();
    }

    @Test
    void should_watch_directives_files() throws Exception {
        Path path = this.generatorProperties.getTmpI18nPath();
        this.builder.start(path);
        ((Watcher)Mockito.verify((Object)this.watcher)).watch((Path)ArgumentMatchers.eq((Object)path), (PathListener)ArgumentMatchers.any(PathListener.class));
    }

    @Test
    void should_not_watch_directives_files() throws Exception {
        this.newLanguagePackBuilder(false);
        Path path = this.generatorProperties.getTmpI18nPath();
        this.builder.start(path);
        ((Watcher)Mockito.verify((Object)this.watcher, (VerificationMode)Mockito.never())).watch((Path)ArgumentMatchers.eq((Object)path), (PathListener)ArgumentMatchers.any(PathListener.class));
    }

    @Test
    void should_ignore_files_which_are_not_po_files() throws Exception {
        Path poFile = Files.createFile(this.tempDir.resolve("fr.po"), new FileAttribute[0]);
        Files.createFile(this.tempDir.resolve("script.js"), new FileAttribute[0]);
        Files.write(poFile, this.aSimplePoFile(), new OpenOption[0]);
        this.builder.start(this.tempDir);
        List jsonFiles = Files.walk(this.generatorProperties.getTmpI18nPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(entry -> entry.getFileName().toString()).collect(Collectors.toList());
        Assertions.assertThat(jsonFiles).containsOnly((Object[])new String[]{"fr.json"});
    }

    @Test
    void should_replace_a_previous_build_with_new_one() throws Exception {
        Path poFile = Files.createFile(this.tempDir.resolve("file.po"), new FileAttribute[0]);
        Files.write(poFile, this.aSimplePoFile(), new OpenOption[0]);
        this.builder.build(poFile);
        Assertions.assertThat((String)this.read(this.generatorProperties.getTmpI18nPath().resolve("file.json").toFile())).isEqualTo("{\"francais\":{\"A page\":\"Une page\"}}");
    }

    private String read(File file) throws IOException {
        return Files.readString(file.toPath());
    }

    public File resolveJson(Path poFile) throws IOException {
        return new File(this.generatorProperties.getTmpI18nPath().resolve(poFile.getFileName().toString().replace(".po", ".json")).toString());
    }

    private byte[] aSimplePoFile() throws Exception {
        return Files.readAllBytes(Paths.get(this.getClass().getResource("/i18n/simple.po").toURI()));
    }
}

