/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.migration.AssetExternalMigrationStep;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.page.Page;
import org.junit.jupiter.api.Test;

class AssetExternalMigrationStepTest {
    AssetExternalMigrationStepTest() {
    }

    @Test
    void should_migrate_artifact_assets() {
        AssetExternalMigrationStep migrationStep = new AssetExternalMigrationStep();
        Page page = PageBuilder.aPage().withAsset(new AssetBuilder[]{AssetBuilder.anAsset().withName("bonita.jpg")}).withAsset(new AssetBuilder[]{AssetBuilder.anAsset().withName("http://www.bonitasoft.com")}).build();
        migrationStep.migrate((Identifiable)page);
        Assertions.assertThat((Collection)page.getAssets()).extracting(new String[]{"name", "external"}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"bonita.jpg", false}), Assertions.tuple((Object[])new Object[]{"http://www.bonitasoft.com", true})});
    }

    @Test
    void should_not_change_an_asset_external_property() {
        AssetExternalMigrationStep migrationStep = new AssetExternalMigrationStep();
        Page page = PageBuilder.aPage().withAsset(new AssetBuilder[]{AssetBuilder.anAsset().withExternal(false).withName("bonita.jpg")}).withAsset(new AssetBuilder[]{AssetBuilder.anAsset().withExternal(true).withName("https://www.bonitasoft.com")}).build();
        migrationStep.migrate((Identifiable)page);
        Assertions.assertThat((Collection)page.getAssets()).extracting(new String[]{"name", "external"}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"bonita.jpg", false}), Assertions.tuple((Object[])new Object[]{"https://www.bonitasoft.com", true})});
    }
}

