/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.workspace.ResourcesCopier;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class ResourcesCopierTest {
    private static String FOLDER_TO_COPY = "tmpCopyResources";
    private static String TARGET_FOLDER = "tmpCopiedResources";
    private Path targetFolder;
    @TempDir
    public Path folderManager;
    private ResourcesCopier resourcesCopier = new ResourcesCopier();

    ResourcesCopierTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.targetFolder = Files.createDirectory(this.folderManager.resolve(TARGET_FOLDER), new FileAttribute[0]);
    }

    @Test
    void should_copy_not_empty_resources_only() throws IOException {
        this.resourcesCopier.copy(this.targetFolder, FOLDER_TO_COPY);
        Path emptyFile = this.targetFolder.resolve(FOLDER_TO_COPY).resolve("empty.po");
        Path file = this.targetFolder.resolve(FOLDER_TO_COPY).resolve("simple.po");
        Path folder = this.targetFolder.resolve(FOLDER_TO_COPY).resolve("pbAutocomplete");
        Path fileIntoFolder = this.targetFolder.resolve(FOLDER_TO_COPY).resolve("pbAutocomplete/pbAutocomplete.json");
        Assertions.assertThat((Path)file).exists();
        Assertions.assertThat((Path)emptyFile).doesNotExist();
        Assertions.assertThat((Path)folder).exists();
        Assertions.assertThat((Path)fileIntoFolder).exists();
    }
}

