/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageUUIDMigrationStep
extends AbstractMigrationStep<Page> {
    private static final Logger logger = LoggerFactory.getLogger(PageUUIDMigrationStep.class);

    @Override
    public Optional<MigrationStepReport> migrate(Page page) throws Exception {
        if (StringUtils.isEmpty((CharSequence)page.getUUID())) {
            String uuid;
            try {
                UUID.fromString(page.getId());
                logger.info("[MIGRATION] Adding UUID to page [{}] (using the same value as the page ID)", (Object)page.getName());
                uuid = page.getId();
            }
            catch (IllegalArgumentException e) {
                logger.info("[MIGRATION] Adding generated UUID to page [{}]", (Object)page.getName());
                uuid = UUID.randomUUID().toString();
            }
            page.setUUID(uuid);
        }
        return Optional.empty();
    }
}

