/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import java.util.Optional;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.model.widget.BondType;
import org.bonitasoft.web.designer.visitor.ComponentVisitor;
import org.bonitasoft.web.designer.visitor.ElementVisitor;

public class TableWidgetInterpretHTMLMigrationStep<T extends AbstractPage>
extends AbstractMigrationStep<T> {
    private ComponentVisitor componentVisitor;

    public TableWidgetInterpretHTMLMigrationStep(ComponentVisitor componentVisitor) {
        this.componentVisitor = componentVisitor;
    }

    @Override
    public Optional<MigrationStepReport> migrate(AbstractPage page) throws Exception {
        for (Component component : (Iterable)page.accept((ElementVisitor)this.componentVisitor)) {
            if (!this.isProvidedTableWidget(component.getId()) || component.getPropertyValues().containsKey("allowHTML")) continue;
            PropertyValue interpretHTMLValue = new PropertyValue();
            interpretHTMLValue.setType(BondType.CONSTANT.toJson());
            interpretHTMLValue.setValue((Object)Boolean.FALSE);
            component.getPropertyValues().put("allowHTML", interpretHTMLValue);
        }
        return Optional.empty();
    }

    private boolean isProvidedTableWidget(String componentId) {
        return "pbTable".equals(componentId) || "pbDataTable".equals(componentId);
    }
}

