/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.web.designer.migration.Migration;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.migrationReport.MigrationResult;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.service.WidgetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentMigrationApplyer {
    private static final Logger logger = LoggerFactory.getLogger(FragmentMigrationApplyer.class);
    private final List<Migration<Fragment>> migrationList;
    private final WidgetService widgetService;

    public FragmentMigrationApplyer(List<Migration<Fragment>> fragmentMigrationStepsList, WidgetService widgetService) {
        this.migrationList = fragmentMigrationStepsList;
        this.widgetService = widgetService;
    }

    public MigrationResult<Fragment> migrate(Fragment fragment, boolean migrateCustomWidgetUsed) {
        Instant startTime = Instant.now();
        String formerArtifactVersion = fragment.getArtifactVersion();
        ArrayList<MigrationStepReport> reports = new ArrayList<MigrationStepReport>();
        for (Migration<Fragment> migration : this.migrationList) {
            reports.addAll(migration.migrate(fragment));
        }
        if (migrateCustomWidgetUsed) {
            reports.addAll(this.migrateAllCustomWidgetUsed(fragment));
        }
        if (!StringUtils.equals((CharSequence)formerArtifactVersion, (CharSequence)fragment.getArtifactVersion())) {
            fragment.setPreviousArtifactVersion(formerArtifactVersion);
            float durationTime = (float)Duration.between(startTime, Instant.now()).toMillis() / 1000.0f;
            logger.info("[MIGRATION] Fragment {} has been terminated in {} seconds!", (Object)fragment.getName(), (Object)Float.valueOf(durationTime));
        }
        return new MigrationResult((Object)fragment, reports);
    }

    public ArtifactStatusReport getMigrationStatusOfCustomWidgetsUsed(Fragment fragment) {
        return this.widgetService.getArtifactStatusOfCustomWidgetUsed((Previewable)fragment);
    }

    private List<MigrationStepReport> migrateAllCustomWidgetUsed(Fragment fragment) {
        return this.widgetService.migrateAllCustomWidgetUsedInPreviewable((Previewable)fragment);
    }
}

