/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.bonitasoft.web.designer.StreamUtils;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.ModalContainer;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;
import org.bonitasoft.web.designer.visitor.ElementVisitor;

public class ComponentVisitor
implements ElementVisitor<Iterable<Component>> {
    private final FragmentRepository fragmentRepository;

    public Iterable<Component> visit(FragmentElement fragmentElement) {
        return (Iterable)((Fragment)this.fragmentRepository.get(fragmentElement.getId())).accept((ElementVisitor)this);
    }

    public Iterable<Component> visit(Container container) {
        return container.getRows().stream().flatMap(Collection::stream).map(element -> (Iterable)element.accept((ElementVisitor)this)).flatMap(StreamUtils::toStream).collect(Collectors.toList());
    }

    public Iterable<Component> visit(FormContainer formContainer) {
        return (Iterable)formContainer.getContainer().accept((ElementVisitor)this);
    }

    public Iterable<Component> visit(TabsContainer tabsContainer) {
        return tabsContainer.getTabList().stream().map(tabContainer -> (Iterable)tabContainer.accept((ElementVisitor)this)).flatMap(StreamUtils::toStream).collect(Collectors.toList());
    }

    public Iterable<Component> visit(TabContainer tabContainer) {
        return (Iterable)tabContainer.getContainer().accept((ElementVisitor)this);
    }

    public Iterable<Component> visit(ModalContainer modalContainer) {
        return (Iterable)modalContainer.getContainer().accept((ElementVisitor)this);
    }

    public Iterable<Component> visit(Component component) {
        return Collections.singleton(component);
    }

    public Iterable<Component> visit(Previewable previewable) {
        Container container = new Container();
        container.setRows(previewable.getRows());
        return (Iterable)container.accept((ElementVisitor)this);
    }

    public ComponentVisitor(FragmentRepository fragmentRepository) {
        this.fragmentRepository = fragmentRepository;
    }
}

