/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.bonitasoft.web.designer.ArtifactBuilder;
import org.bonitasoft.web.designer.ArtifactBuilderFactory;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.config.UiDesignerPropertiesBuilder;
import org.bonitasoft.web.designer.controller.importer.report.ImportReport;
import org.bonitasoft.web.designer.controller.utils.Unzipper;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class ArtifactBuilderIT {
    private UiDesignerProperties properties;
    private ArtifactBuilder artifactBuilder;
    private Unzipper unziper = new Unzipper();
    @TempDir
    public Path tempFolder;

    @BeforeEach
    void setUp() throws Exception {
        this.properties = new UiDesignerPropertiesBuilder().workspacePath(Path.of("./target/ArtifactBuilderIT/project", new String[0])).workspaceUidPath(Path.of("./target/ArtifactBuilderIT/uid", new String[0])).build();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> {
            try {
                FileUtils.deleteDirectory((File)this.properties.getWorkspace().getPages().getDir().toFile());
                FileUtils.deleteDirectory((File)this.properties.getWorkspace().getFragments().getDir().toFile());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    @Test
    void should_import_custom_widget_without_prefix() throws Exception {
        Path timelineWidgetToImportPath = Files.createDirectory(this.tempFolder.resolve("timelineWidget"), new FileAttribute[0]);
        FileUtils.copyDirectory((File)Path.of("src/test/resources/import/timelineWidget", new String[0]).toFile(), (File)timelineWidgetToImportPath.toFile());
        this.artifactBuilder = new ArtifactBuilderFactory(this.properties).create();
        ImportReport importReport = this.artifactBuilder.importWidget(timelineWidgetToImportPath, true);
        String loadedControler = ((Widget)importReport.getElement()).getController();
        String loadedTemplate = ((Widget)importReport.getElement()).getTemplate();
        byte[] widget = this.artifactBuilder.buildWidget("timelineWidget");
        Path timelineWidgetPath = this.unziper.unzipInTempDir((InputStream)new ByteArrayInputStream(widget), "timelineWidget");
        Assertions.assertThat((String)loadedControler).doesNotStartWith((CharSequence)"@");
        Assertions.assertThat((String)loadedTemplate).doesNotStartWith((CharSequence)"@");
        Assertions.assertThat((Path)timelineWidgetPath.resolve("resources/widget.json")).exists();
        Assertions.assertThat((String)Files.readString(timelineWidgetPath.resolve("resources/widget.json"))).contains(new CharSequence[]{"\"template\":\"@timelineWidget.tpl.html\","});
        Assertions.assertThat((String)Files.readString(timelineWidgetPath.resolve("resources/widget.json"))).contains(new CharSequence[]{"\"controller\":\"@timelineWidget.ctrl.js\","});
        Assertions.assertThat((Path)timelineWidgetPath.resolve("resources/timelineWidget.ctrl.js")).exists();
        Assertions.assertThat((File)timelineWidgetPath.resolve("resources/timelineWidget.ctrl.js").toFile()).hasContent(loadedControler);
        Assertions.assertThat((Path)timelineWidgetPath.resolve("resources/timelineWidget.tpl.html")).exists();
        Assertions.assertThat((File)timelineWidgetPath.resolve("resources/timelineWidget.tpl.html").toFile()).hasContent(loadedTemplate);
        Assertions.assertThat((Path)timelineWidgetPath.resolve("resources/timelineWidget.js")).exists();
    }

    @Test
    void should_export_page() throws Exception {
        String pageId = "ma-page";
        this.createPage(pageId);
        this.createFragment("person");
        this.createFragment("details");
        this.artifactBuilder = new ArtifactBuilderFactory(this.properties).create();
        byte[] page = this.artifactBuilder.buildPage(pageId);
        List<String> zipEntriesName = this.extractZipEntriesName(page);
        Assertions.assertThat((byte[])page).isNotEmpty();
        Assertions.assertThat(zipEntriesName).contains((Object[])new String[]{"resources/page.json"});
        Assertions.assertThat(zipEntriesName).contains((Object[])new String[]{"resources/fragments/person/person.json"});
        Assertions.assertThat(zipEntriesName).contains((Object[])new String[]{"resources/fragments/details/details.json"});
    }

    @Test
    void should_export_fragment() throws Exception {
        String fragmentPerson = "person";
        this.createFragment(fragmentPerson);
        this.createFragment("details");
        this.artifactBuilder = new ArtifactBuilderFactory(this.properties).create();
        byte[] page = this.artifactBuilder.buildFragment(fragmentPerson);
        List<String> zipEntriesName = this.extractZipEntriesName(page);
        Assertions.assertThat((byte[])page).isNotEmpty();
        Assertions.assertThat(zipEntriesName).contains((Object[])new String[]{"resources/fragment.json"});
        Assertions.assertThat(zipEntriesName).contains((Object[])new String[]{"resources/fragments/details/details.json"});
    }

    @Test
    void should_index_pages() throws Exception {
        this.createPage("ma-page");
        this.artifactBuilder = new ArtifactBuilderFactory(this.properties).create();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertThat((Path)this.properties.getWorkspace().getPages().getDir().resolve(".metadata/.index.json")).exists());
    }

    @Test
    void should_watch_pages() throws Exception {
        String pageId = "ma-page";
        Path target = this.properties.getWorkspace().getPages().getDir().resolve(pageId);
        Path source = Path.of("./src/test/resources/workspace/pages/" + pageId, new String[0]);
        this.createPage(pageId);
        this.artifactBuilder = new ArtifactBuilderFactory(this.properties).create();
        Path jsonIndex = this.properties.getWorkspace().getPages().getDir().resolve(".metadata/.index.json");
        FileUtils.deleteDirectory((File)target.toFile());
        FileUtils.deleteQuietly((File)jsonIndex.toFile());
        FileUtils.copyDirectory((File)source.toFile(), (File)target.toFile());
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertThat((Path)jsonIndex).exists());
    }

    private void createPage(String pageId) throws IOException {
        Path target = this.properties.getWorkspace().getPages().getDir().resolve(pageId);
        Path source = Path.of("./src/test/resources/workspace/pages/" + pageId, new String[0]);
        FileUtils.copyDirectory((File)source.toFile(), (File)target.toFile());
    }

    private void createFragment(String fragmentId) throws IOException {
        Path target = this.properties.getWorkspace().getFragments().getDir().resolve(fragmentId);
        Path source = Path.of("./src/test/resources/workspace/fragments/" + fragmentId, new String[0]);
        FileUtils.copyDirectory((File)source.toFile(), (File)target.toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> extractZipEntriesName(byte[] content) throws IOException {
        ArrayList<String> entries = new ArrayList<String>();
        try (ZipInputStream zi = null;){
            zi = new ZipInputStream(new ByteArrayInputStream(content));
            ZipEntry zipEntry = null;
            while ((zipEntry = zi.getNextEntry()) != null) {
                entries.add(zipEntry.getName());
            }
        }
        return entries;
    }
}

