/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.controller.importer.report.Dependencies;
import org.bonitasoft.web.designer.controller.importer.report.ImportReport;
import org.bonitasoft.web.designer.model.Identifiable;

public class ImportReportBuilder {
    private Identifiable element;
    List<Identifiable> added = new ArrayList<Identifiable>();
    List<Identifiable> overwritten = new ArrayList<Identifiable>();
    private String uuid;
    private ImportReport.Status status;
    private boolean overwrite;

    public ImportReportBuilder(Identifiable element) {
        this.element = element;
    }

    public static ImportReportBuilder anImportReportFor(PageBuilder builder) {
        return new ImportReportBuilder((Identifiable)builder.build());
    }

    public static ImportReportBuilder anImportReportFor(WidgetBuilder builder) {
        return new ImportReportBuilder((Identifiable)builder.build());
    }

    public static ImportReportBuilder anImportReportFor(FragmentBuilder builder) {
        return new ImportReportBuilder((Identifiable)builder.build());
    }

    public ImportReportBuilder withAdded(WidgetBuilder builder) {
        this.added.add((Identifiable)builder.build());
        return this;
    }

    public ImportReportBuilder withOverwritten(WidgetBuilder builder) {
        this.overwritten.add((Identifiable)builder.build());
        return this;
    }

    public ImportReportBuilder withUUID(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public ImportReportBuilder withOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public ImportReportBuilder withStatus(ImportReport.Status status) {
        this.status = status;
        return this;
    }

    public ImportReport build() {
        Dependencies dependencies = new Dependencies();
        for (Identifiable identifiable : this.added) {
            dependencies.addAddedDependency(identifiable.getClass().getSimpleName().toLowerCase(Locale.ENGLISH), (Object)identifiable);
        }
        for (Identifiable identifiable : this.overwritten) {
            dependencies.addOverwrittenDependency(identifiable.getClass().getSimpleName().toLowerCase(Locale.ENGLISH), (Object)identifiable);
        }
        ImportReport importReport = new ImportReport(this.element, dependencies);
        importReport.setUUID(this.uuid);
        importReport.setOverwritten(Boolean.valueOf(this.overwrite));
        importReport.setStatus(this.status);
        return importReport;
    }
}

