/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.TreeMap;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.controller.export.properties.PagePropertiesBuilder;
import org.bonitasoft.web.designer.model.data.Data;
import org.bonitasoft.web.designer.model.data.DataType;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.service.DefaultPageService;
import org.bonitasoft.web.designer.service.PageService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class PagePropertiesBuilderTest {
    private static final String DESIGNER_VERSION = "1.12.1";
    private PagePropertiesBuilder pagePropertiesBuilder;
    private Page page;
    @Mock
    private DefaultPageService pageService;

    PagePropertiesBuilderTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.page = new Page();
        this.page.setName("myPage");
        UiDesignerProperties uiDesignerProperties = new UiDesignerProperties();
        uiDesignerProperties.setVersion(DESIGNER_VERSION);
        this.pagePropertiesBuilder = new PagePropertiesBuilder(uiDesignerProperties, (PageService)this.pageService);
    }

    private Data anApiData(String value) {
        return new Data(DataType.URL, (Object)value);
    }

    @Test
    void should_build_a_well_formed_page_property_file() throws Exception {
        this.page.setId("aPageId");
        this.page.setName("aPageName");
        this.page.setDescription("a page description with special characters &'\"\u00e9");
        this.page.setDisplayName("a display name with special characters &'\"\u00e9");
        Mockito.when((Object)this.pageService.getResources(this.page)).thenReturn(Arrays.asList(""));
        String properties = new String(this.pagePropertiesBuilder.build(this.page));
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"contentType=page"});
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"name=custompage_aPageName"});
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"displayName=a display name with special characters &'\"\\u00E9"});
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"description=a page description with special characters &'\"\\u00E9"});
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"resources=[]"});
    }

    @Test
    void should_build_a_page_property_file_when_description_and_displayName_are_not_updated() throws Exception {
        this.page.setId("aPageId");
        this.page.setName("aPageName");
        this.page.setDesignerVersion(DESIGNER_VERSION);
        String properties = new String(this.pagePropertiesBuilder.build(this.page));
        Mockito.lenient().when((Object)this.pageService.getResources(this.page)).thenReturn(Arrays.asList(""));
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"contentType=page"});
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"name=custompage_aPageName"});
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"displayName=aPageName"});
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"description=Page generated with Bonita UI designer"});
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"resources=[]"});
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"designerVersion=1.12.1"});
    }

    @Test
    void should_build_a_page_property_file_with_designerVersion() throws Exception {
        this.page.setDesignerVersion(DESIGNER_VERSION);
        String properties = new String(this.pagePropertiesBuilder.build(this.page));
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"designerVersion=1.12.1"});
    }

    @Test
    void should_add_bonita_resource_found_in_page_data() throws Exception {
        this.page.setData(Collections.singletonMap("foo", this.anApiData("/bonita/API/living/application-menu")));
        Mockito.when((Object)this.pageService.getResources(this.page)).thenReturn(Arrays.asList("GET|living/application-menu"));
        String properties = new String(this.pagePropertiesBuilder.build(this.page));
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"resources=[GET|living/application-menu]"});
    }

    @Test
    void should_add_relative_bonita_resource_found_in_page_data() throws Exception {
        TreeMap<String, Data> dataMap = new TreeMap<String, Data>();
        dataMap.put("foo", this.anApiData("../API/bpm/userTask?filter=mine"));
        dataMap.put("bar", this.anApiData("../API/identity/user/1"));
        dataMap.put("other", this.anApiData("../API/identity/group/1?param=value"));
        dataMap.put("archived", this.anApiData("../API/bpm/archivedUserTask?filter=mine&o=name DESC"));
        this.page.setData(dataMap);
        Mockito.when((Object)this.pageService.getResources(this.page)).thenReturn(Arrays.asList("GET|bpm/archivedUserTask", "GET|identity/user", "GET|bpm/userTask", "GET|identity/group"));
        String properties = new String(this.pagePropertiesBuilder.build(this.page));
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"resources=[GET|bpm/archivedUserTask, GET|identity/user, GET|bpm/userTask, GET|identity/group]"});
    }

    @Test
    void should_not_add_a_resource_which_is_not_a_bonita_resource() throws Exception {
        this.page.setData(Collections.singletonMap("foo", this.anApiData("../API/path/to/wathever/resource")));
        Mockito.when((Object)this.pageService.getResources(this.page)).thenReturn(Arrays.asList(""));
        String properties = new String(this.pagePropertiesBuilder.build(this.page));
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"resources=[]"});
    }

    @Test
    void should_add_contentType() throws Exception {
        this.page.setType("layout");
        Mockito.when((Object)this.pageService.getResources(this.page)).thenReturn(Arrays.asList(""));
        String properties = new String(this.pagePropertiesBuilder.build(this.page));
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"contentType=layout"});
    }
}

