/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.properties;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.controller.export.properties.WidgetPropertiesBuilder;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class WidgetPropertiesBuilderTest {
    private static final String DESIGNER_VERSION = "1.12.1";
    private WidgetPropertiesBuilder widgetPropertiesBuilder;
    private Widget widget;

    WidgetPropertiesBuilderTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        UiDesignerProperties uiDesignerProperties = new UiDesignerProperties();
        uiDesignerProperties.setVersion(DESIGNER_VERSION);
        this.widgetPropertiesBuilder = new WidgetPropertiesBuilder(uiDesignerProperties);
        this.widget = new Widget();
        this.widget.setName("myWidget");
    }

    @Test
    void should_build_a_well_formed_page_property_file() throws Exception {
        this.widget.setDesignerVersion(DESIGNER_VERSION);
        byte[] a = this.widgetPropertiesBuilder.build(this.widget);
        String properties = new String(a);
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"contentType=widget"});
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"name=myWidget"});
        Assertions.assertThat((String)properties).contains(new CharSequence[]{"designerVersion=1.12.1"});
    }
}

