/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.steps;

import java.nio.file.Path;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.common.export.Zipper;
import org.bonitasoft.web.designer.common.repository.AssetRepository;
import org.bonitasoft.web.designer.controller.export.steps.AssetExportStep;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.page.Page;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class AssetExportStepTest {
    @Mock
    private AssetRepository<Page> pageAssetRepository;
    @Mock
    private Zipper zipper;
    @Mock
    private Path assetPath;
    @InjectMocks
    private AssetExportStep assetExportStep;

    AssetExportStepTest() {
    }

    @Test
    void should_call_zipper_when_page_has_no_asset() throws Exception {
        this.assetExportStep.execute(this.zipper, PageBuilder.aPage().build());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.zipper});
    }

    @Test
    void should_export_asset_when_page_has_asset() throws Exception {
        Mockito.when((Object)this.pageAssetRepository.findAssetPath("pageId", "myfile.css", AssetType.CSS)).thenReturn((Object)this.assetPath);
        Page page = PageBuilder.aPage().withId("pageId").withAsset(new AssetBuilder[]{AssetBuilder.anAsset().withName("myfile.css").withType(AssetType.CSS)}).build();
        this.assetExportStep.execute(this.zipper, page);
        ((Zipper)Mockito.verify((Object)this.zipper)).addDirectoryToZip(this.assetPath, Zipper.ALL_DIRECTORIES, Zipper.ALL_FILES, "resources/assets/css/myfile.css");
    }

    @Test
    void should_not_export_external_assets() throws Exception {
        Page page = PageBuilder.aPage().withAsset(new AssetBuilder[]{AssetBuilder.anAsset().withName("http://external.asset").withExternal(true)}).build();
        this.assetExportStep.execute(this.zipper, page);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.zipper});
    }
}

