/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.steps;

import java.io.OutputStream;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.angularjs.export.IncludeChildDirectoryPredicate;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.common.export.Zipper;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.common.visitor.FragmentIdVisitor;
import org.bonitasoft.web.designer.config.WorkspaceProperties;
import org.bonitasoft.web.designer.controller.export.steps.FragmentsExportStep;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.utils.rule.TemporaryFragmentRepository;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class FragmentsExportStepTest {
    private final WorkspaceProperties workspaceProperties = new WorkspaceProperties();
    public TemporaryFragmentRepository repositoryFactory = new TemporaryFragmentRepository(this.workspaceProperties);
    private FragmentRepository fragmentRepository;
    private FragmentsExportStep step;
    @Mock
    private Zipper zipper;
    @TempDir
    Path tempPath;

    FragmentsExportStepTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.repositoryFactory.init(this.tempPath);
        this.fragmentRepository = this.repositoryFactory.toRepository();
        this.step = new FragmentsExportStep(new FragmentIdVisitor(this.fragmentRepository), this.workspaceProperties.getFragments().getDir());
        this.zipper = (Zipper)Mockito.spy((Object)new Zipper((OutputStream)Mockito.mock(OutputStream.class)));
    }

    @Test
    void should_add_fragments_to_zip() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().withId("fragment").build();
        this.fragmentRepository.save((Identifiable)fragment);
        this.step.execute(this.zipper, (AbstractPage)fragment);
        ArgumentCaptor importPathCaptor = ArgumentCaptor.forClass(Path.class);
        ArgumentCaptor directoryPredicateCaptor = ArgumentCaptor.forClass(IncludeChildDirectoryPredicate.class);
        ArgumentCaptor destinationDirectoryNameCaptor = ArgumentCaptor.forClass(String.class);
        ((Zipper)Mockito.verify((Object)this.zipper)).addDirectoryToZip((Path)importPathCaptor.capture(), (Zipper.PathPredicate)directoryPredicateCaptor.capture(), (Zipper.FilePredicate)ArgumentMatchers.eq((Object)Zipper.ALL_FILES), (String)destinationDirectoryNameCaptor.capture());
        Assertions.assertThat((Path)((Path)importPathCaptor.getValue())).isEqualTo((Object)this.tempPath);
        Assertions.assertThat((Path)((IncludeChildDirectoryPredicate)directoryPredicateCaptor.getValue()).getSourceDirectory()).isEqualTo((Object)this.tempPath);
        Assertions.assertThat((String)((String)destinationDirectoryNameCaptor.getValue())).isEqualTo("resources/" + this.fragmentRepository.getComponentName() + "s");
    }

    @Test
    void should_not_add_fragment_metadata_to_zip() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().withId("fragment").build();
        this.fragmentRepository.save((Identifiable)fragment);
        this.step.execute(this.zipper, (AbstractPage)fragment);
        ((Zipper)Mockito.verify((Object)this.zipper, (VerificationMode)Mockito.never())).addToZip(this.repositoryFactory.resolveFragmentMetadata("fragment"), "resources/fragments/fragment/fragment.metadata.json");
    }
}

