/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer.dependencies;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.common.repository.AssetRepository;
import org.bonitasoft.web.designer.controller.importer.dependencies.AssetDependencyImporter;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.page.Page;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class AssetDependencyImporterTest {
    @Mock
    AssetRepository<Page> pageAssetRepository;
    @InjectMocks
    AssetDependencyImporter<Page> pageAssetDependencyImporter;
    @TempDir
    Path zipBaseDir;

    AssetDependencyImporterTest() {
    }

    void createDirectoryAsset(String assetType) throws IOException {
        Files.createDirectory(this.zipBaseDir.resolve("assets"), new FileAttribute[0]);
        Files.createDirectory(this.zipBaseDir.resolve("assets").resolve(assetType), new FileAttribute[0]);
    }

    @Test
    void should_not_thrown_exception_when_page_has_no_asset() throws Exception {
        List assets = this.pageAssetDependencyImporter.load((Identifiable)PageBuilder.aPage().build(), this.zipBaseDir);
        Assertions.assertThat((List)assets).isEmpty();
    }

    @Test
    void should_load_assets() throws Exception {
        Page page = PageBuilder.aPage().build();
        this.createDirectoryAsset("css");
        Files.write(this.zipBaseDir.resolve("assets").resolve("css").resolve("myfile.css"), "<style>.maclass1{}</style>".getBytes(), new OpenOption[0]);
        ArrayList<Asset> assetsReturned = new ArrayList<Asset>();
        assetsReturned.add(new Asset().setName("myfile.css"));
        Mockito.when((Object)this.pageAssetRepository.findAssetInPath((Identifiable)page, AssetType.CSS, this.zipBaseDir.resolve("assets").resolve("css"))).thenReturn(assetsReturned);
        List assets = this.pageAssetDependencyImporter.load((Identifiable)page, this.zipBaseDir);
        Assertions.assertThat((List)assets).isNotEmpty();
    }

    @Test
    void should_save_assets_from_zip_with_assets_folder_at_root() throws Exception {
        Asset cssAsset = AssetBuilder.anAsset().withScope("widget").withComponentId("widgetId").withId("aa").withType(AssetType.CSS).withName("style.css").build();
        this.createDirectoryAsset("css");
        byte[] content = "<style>.maclass1{}</style>".getBytes();
        Files.write(this.zipBaseDir.resolve("assets").resolve("css").resolve("style.css"), content, new OpenOption[0]);
        this.pageAssetDependencyImporter.save(Collections.singletonList(cssAsset), this.zipBaseDir);
        ((AssetRepository)Mockito.verify(this.pageAssetRepository, (VerificationMode)Mockito.times((int)1))).save(cssAsset, content);
    }

    @Test
    void should_save_assets_from_zip_with_assets_folder_contains_in_folder_with_widgetId_as_name() throws Exception {
        Asset cssAsset = AssetBuilder.anAsset().withScope("widget").withComponentId("customWidget").withId("aa").withType(AssetType.CSS).withName("style.css").build();
        Files.createDirectories(this.zipBaseDir.resolve("customWidget").resolve("assets").resolve("css"), new FileAttribute[0]);
        byte[] content = "<style>.maclass1{}</style>".getBytes();
        Files.write(this.zipBaseDir.resolve("customWidget").resolve("assets").resolve("css").resolve("style.css"), content, new OpenOption[0]);
        this.pageAssetDependencyImporter.save(Collections.singletonList(cssAsset), this.zipBaseDir);
        ((AssetRepository)Mockito.verify(this.pageAssetRepository, (VerificationMode)Mockito.times((int)1))).save(cssAsset, content);
    }
}

