/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer.dependencies;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.controller.importer.dependencies.FragmentDependencyImporter;
import org.bonitasoft.web.designer.model.Identifiable;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class FragmentDependencyImporterTest {
    @Mock
    private FragmentRepository fragmentRepository;
    @InjectMocks
    private FragmentDependencyImporter fragmentImporterDependencyImporter;

    FragmentDependencyImporterTest() {
    }

    @Test
    void should_verify_that_a_fragment_exists_in_repository() throws Exception {
        Mockito.when((Object)this.fragmentRepository.exists("existingFragment")).thenReturn((Object)true);
        boolean exists = this.fragmentImporterDependencyImporter.exists((Identifiable)FragmentBuilder.aFragment().withId("existingFragment").build());
        Assertions.assertThat((boolean)exists).isTrue();
    }

    @Test
    void should_verify_that_a_widget_does_not_exists_in_repository() throws Exception {
        Mockito.when((Object)this.fragmentRepository.exists("unknownFragment")).thenReturn((Object)false);
        boolean exists = this.fragmentImporterDependencyImporter.exists((Identifiable)FragmentBuilder.aFragment().withId("unknownFragment").build());
        Assertions.assertThat((boolean)exists).isFalse();
    }
}

