/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer.mocks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.mockito.Mockito;

public class WidgetImportMock {
    private static final String WIDGETS_FOLDER = "widgets";
    private final Path unzippedPath;
    private final WidgetRepository widgetRepository;
    private final List<Widget> widgets = new ArrayList<Widget>();

    public WidgetImportMock(Path unzippedPath, WidgetRepository widgetRepository) throws IOException {
        this.unzippedPath = unzippedPath;
        this.widgetRepository = widgetRepository;
    }

    public List<Widget> mockWidgetsAsAddedDependencies() throws IOException {
        return this.mockWidgetsAsAddedDependencies(WidgetBuilder.aWidget().withId("aWidget").custom(), WidgetBuilder.aWidget().withId("anotherWidget").custom());
    }

    public List<Widget> mockWidgetsAsAddedDependencies(WidgetBuilder ... widgetBuilders) throws IOException {
        List<Widget> widgets = Arrays.stream(widgetBuilders).map(WidgetBuilder::build).collect(Collectors.toList());
        Files.createDirectories(this.unzippedPath.resolve(WIDGETS_FOLDER), new FileAttribute[0]);
        this.widgets.addAll(widgets);
        Mockito.when((Object)this.widgetRepository.getComponentName()).thenReturn((Object)"widget");
        Mockito.when((Object)this.widgetRepository.loadAll(this.unzippedPath.resolve(WIDGETS_FOLDER), WidgetRepository.CUSTOM_WIDGET_FILTER)).thenReturn(this.widgets);
        return widgets;
    }

    public List<Widget> mockWidgetsAsOverridenDependencies() throws IOException {
        Files.createDirectories(this.unzippedPath.resolve(WIDGETS_FOLDER), new FileAttribute[0]);
        Widget alreadyThereWidget = WidgetBuilder.aWidget().withId("alreadyThereWidget").custom().build();
        Widget anotherExistingWidget = WidgetBuilder.aWidget().withId("anotherExistingWidget").custom().build();
        List<Widget> widgets = Arrays.asList(alreadyThereWidget, anotherExistingWidget);
        this.widgets.addAll(widgets);
        Mockito.when((Object)this.widgetRepository.getComponentName()).thenReturn((Object)"widget");
        Mockito.when((Object)this.widgetRepository.loadAll(this.unzippedPath.resolve(WIDGETS_FOLDER), WidgetRepository.CUSTOM_WIDGET_FILTER)).thenReturn(this.widgets);
        Mockito.when((Object)this.widgetRepository.exists("alreadyThereWidget")).thenReturn((Object)true);
        Mockito.when((Object)this.widgetRepository.exists("anotherExistingWidget")).thenReturn((Object)true);
        Mockito.when((Object)((Widget)this.widgetRepository.get("alreadyThereWidget"))).thenReturn((Object)alreadyThereWidget);
        Mockito.when((Object)((Widget)this.widgetRepository.get("anotherExistingWidget"))).thenReturn((Object)anotherExistingWidget);
        return widgets;
    }
}

