/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.i18n;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bonitasoft.web.angularjs.GeneratorProperties;
import org.bonitasoft.web.designer.i18n.I18nInitializer;
import org.bonitasoft.web.designer.i18n.LanguagePackBuilder;
import org.bonitasoft.web.designer.workspace.ResourcesCopier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class I18nInitializerTest {
    @Mock
    private GeneratorProperties generatorProperties;
    @Mock
    private ResourcesCopier resourcesCopier;
    @Mock
    private LanguagePackBuilder languagePackBuilder;
    @InjectMocks
    private I18nInitializer i18nInitializer;

    I18nInitializerTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        Mockito.when((Object)this.generatorProperties.getExtractPath()).thenReturn((Object)Paths.get("target/test-classes", new String[0]));
    }

    @Test
    void should_start_live_build_on_po_directory() throws Exception {
        this.i18nInitializer.initialize();
        ((LanguagePackBuilder)Mockito.verify((Object)this.languagePackBuilder)).start(this.generatorProperties.getExtractPath().resolve("i18n"));
    }

    @Test
    void should_throw_a_runtime_exception_on_io_error() throws Exception {
        ((LanguagePackBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.languagePackBuilder)).start((Path)ArgumentMatchers.any(Path.class));
        Assertions.assertThrows(RuntimeException.class, () -> this.i18nInitializer.initialize());
    }
}

