/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.migration.DataExposedMigrationStep;
import org.bonitasoft.web.designer.model.data.DataType;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class DataExposedMigrationStepTest {
    DataExposedMigrationStep dataExposedMigrationStep;

    DataExposedMigrationStepTest() {
    }

    @BeforeEach
    void setUp() {
        this.dataExposedMigrationStep = new DataExposedMigrationStep();
    }

    @Test
    void should_migrate_fragment_when_data_is_exposed() throws Exception {
        Fragment fragment = FragmentBuilder.aFilledFragment((String)"myFragment");
        Variable variable = new Variable(DataType.JSON, "{}");
        variable.setExposed(true);
        fragment.addVariable("myExposedVariable", variable);
        this.dataExposedMigrationStep.migrate(fragment);
        Assertions.assertThat((boolean)((Variable)fragment.getVariables().get("myExposedVariable")).isExposed()).isTrue();
        Assertions.assertThat((Comparable)((Variable)fragment.getVariables().get("myExposedVariable")).getType()).isEqualTo((Object)DataType.CONSTANT);
        Assertions.assertThat((List)((Variable)fragment.getVariables().get("myExposedVariable")).getValue()).isEqualTo(List.of(""));
    }

    @Test
    void should_not_migrate_fragment_when_data_is_not_exposed() throws Exception {
        Fragment fragment = FragmentBuilder.aFilledFragment((String)"myFragment");
        Variable variable = new Variable(DataType.JSON, "{}");
        variable.setExposed(false);
        fragment.addVariable("myNotExposedVariable", variable);
        this.dataExposedMigrationStep.migrate(fragment);
        Assertions.assertThat((boolean)((Variable)fragment.getVariables().get("myNotExposedVariable")).isExposed()).isFalse();
        Assertions.assertThat((Comparable)((Variable)fragment.getVariables().get("myNotExposedVariable")).getType()).isEqualTo((Object)DataType.JSON);
        Assertions.assertThat((List)((Variable)fragment.getVariables().get("myNotExposedVariable")).getValue()).isEqualTo(List.of("{}"));
    }
}

