/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.migration.LocalizationAddErrorDialogTranslationsMigrationStep;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.page.Page;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class LocalizationAddErrorDialogTranslationsMigrationStepTest {
    @Mock
    private AssetService<Page> pageAssetService;
    @InjectMocks
    private LocalizationAddErrorDialogTranslationsMigrationStep step;

    LocalizationAddErrorDialogTranslationsMigrationStepTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.step = new LocalizationAddErrorDialogTranslationsMigrationStep(this.pageAssetService);
    }

    private Asset expectedAsset(String name) {
        return AssetBuilder.anAsset().withType(AssetType.JSON).withName(name).build();
    }

    @Test
    void should_migrate_localization_asset_to_add_new_error_dialog_translations() throws Exception {
        Asset json = AssetBuilder.anAsset().withType(AssetType.JSON).withName("localization.json").build();
        InputStream initialContent = this.getClass().getResourceAsStream("initialLocalization.json");
        Page page = PageBuilder.aPage().withModelVersion("2.5").withAsset(new Asset[]{json}).build();
        Mockito.when((Object)this.pageAssetService.getAssetBinaryContent((Assetable)page, json)).thenReturn((Object)IOUtils.toByteArray((InputStream)initialContent));
        this.step.migrate(page);
        InputStream expectedContent = this.getClass().getResourceAsStream("expectedLocalization.json");
        ((AssetService)Mockito.verify(this.pageAssetService)).save((Assetable)page, this.expectedAsset("localization.json"), IOUtils.toByteArray((InputStream)expectedContent));
    }
}

