/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.migration.StyleAddErrorDialogPropertiesMigrationStep;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.page.Page;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class StyleAddErrorDialogPropertiesMigrationStepTest {
    @Mock
    private AssetService<Page> pageAssetService;
    @InjectMocks
    private StyleAddErrorDialogPropertiesMigrationStep step;

    StyleAddErrorDialogPropertiesMigrationStepTest() {
    }

    @BeforeEach
    void setUp() {
        this.step = new StyleAddErrorDialogPropertiesMigrationStep(this.pageAssetService);
    }

    private Asset expectedAsset(String name) {
        return AssetBuilder.anAsset().withType(AssetType.CSS).withName(name).build();
    }

    @Test
    void should_migrate_style_asset_to_add_new_error_dialog_css_classes() throws Exception {
        Asset style = AssetBuilder.anAsset().withType(AssetType.CSS).withName("style.css").build();
        String initContent = ".my-content {background: red}";
        Page page = PageBuilder.aPage().withModelVersion("2.5").withAsset(new Asset[]{style}).build();
        Mockito.when((Object)this.pageAssetService.getAssetContent((Assetable)page, style)).thenReturn((Object)initContent);
        InputStream is = this.getClass().getResourceAsStream("/templates/migration/assets/css/styleAddErrorDialogProperties.css");
        this.step.migrate(page);
        String expectedContent = initContent.concat("\n\n").concat(IOUtils.toString((InputStream)is));
        ((AssetService)Mockito.verify(this.pageAssetService)).save((Assetable)page, this.expectedAsset("style.css"), expectedContent.getBytes());
    }
}

