/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ElementBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.RowBuilder;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.migration.page.SetInterpretHtmlTrueMigrationStep;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.visitor.ComponentVisitor;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class SetInterpretHtmlTrueMigrationStepTest {
    @Mock
    private FragmentRepository fragmentRepository;
    SetInterpretHtmlTrueMigrationStep<Page> setInterpretHtmlTrueMigrationStep;

    SetInterpretHtmlTrueMigrationStepTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.setInterpretHtmlTrueMigrationStep = new SetInterpretHtmlTrueMigrationStep(new ComponentVisitor(this.fragmentRepository));
    }

    @Test
    void should_migrate_page_with_added_AllowHTML() throws Exception {
        RowBuilder row = RowBuilder.aRow().with(new ElementBuilder[]{ComponentBuilder.aComponent((String)"pbButton")});
        Page pageWithButton = PageBuilder.aPage().withId("pageWithButton").withModelVersion("2.2").with(row.build().toArray(new Element[0])).build();
        this.setInterpretHtmlTrueMigrationStep.migrate((AbstractPage)pageWithButton);
        this.checkAllowHtmlTrue((AbstractPage)pageWithButton);
    }

    @Test
    void should_migrate_fragment_with_added_AllowHTML() throws Exception {
        RowBuilder row = RowBuilder.aRow().with(new ElementBuilder[]{ComponentBuilder.aComponent((String)"pbCheckbox")});
        Fragment fragmentWithCheckbox = FragmentBuilder.aFragment().withId("fragmentWithCheckbox").withModelVersion("2.2").with(row.build().toArray(new Element[0])).build();
        this.setInterpretHtmlTrueMigrationStep.migrate((AbstractPage)fragmentWithCheckbox);
        this.checkAllowHtmlTrue((AbstractPage)fragmentWithCheckbox);
    }

    private void checkAllowHtmlTrue(AbstractPage abstractPage) {
        Map propertyValues = ((Element)((List)abstractPage.getRows().get(0)).get(0)).getPropertyValues();
        Assertions.assertThat((boolean)propertyValues.containsKey("allowHTML")).isTrue();
        Assertions.assertThat((Object)((PropertyValue)propertyValues.get("allowHTML")).getValue()).isEqualTo((Object)Boolean.TRUE);
    }
}

