/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.utils.rule;

import java.nio.file.Path;
import org.bonitasoft.web.designer.Version;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.common.livebuild.Watcher;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedLoader;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedPersister;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.config.WorkspaceProperties;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonHandlerFactory;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.mockito.Mockito;

public class TemporaryFragmentRepository {
    private final JsonHandler jsonHandler = new JsonHandlerFactory().create();
    private FragmentRepository repository;
    private final WorkspaceProperties workspaceProperties;
    private Path tempPath;

    public void init(Path tempDir) {
        this.tempPath = tempDir;
        UiDesignerProperties uiDesignerProperties = new UiDesignerProperties("1.13.0", Version.MODEL_VERSION);
        this.workspaceProperties.getFragments().setDir(this.tempPath);
        uiDesignerProperties.setWorkspace(this.workspaceProperties);
        BeanValidator validator = (BeanValidator)Mockito.mock(BeanValidator.class);
        Watcher watcher = (Watcher)Mockito.mock(Watcher.class);
        this.repository = new FragmentRepository(uiDesignerProperties.getWorkspace().getFragments().getDir(), uiDesignerProperties.getWorkspaceUid().getExtractPath().resolve("angularjs").resolve("templates"), new JsonFileBasedPersister(this.jsonHandler, validator, uiDesignerProperties.getVersion(), uiDesignerProperties.getModelVersion()), new JsonFileBasedLoader(this.jsonHandler, Fragment.class), validator, watcher);
    }

    public TemporaryFragmentRepository(WorkspaceProperties workspaceProperties) {
        this.workspaceProperties = workspaceProperties;
    }

    public FragmentRepository toRepository() {
        return this.repository;
    }

    public Path resolveFragmentJson(String id) {
        return this.tempPath.resolve(String.format("%s/%s.json", id, id));
    }

    public Path resolveFragmentMetadata(String id) {
        return this.tempPath.resolve(String.format("%s/%s.metadata.json", id, id));
    }

    public Fragment addFragment(FragmentBuilder fragmentBuilder) {
        return (Fragment)this.repository.save((Identifiable)fragmentBuilder.build());
    }
}

