/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.angularjs.rendering.TemplateEngine;
import org.bonitasoft.web.angularjs.visitor.HtmlBuilderVisitor;
import org.bonitasoft.web.angularjs.workspace.FragmentDirectiveBuilder;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.common.livebuild.PathListener;
import org.bonitasoft.web.designer.common.livebuild.Watcher;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonHandlerFactory;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Element;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class FragmentDirectiveBuilderTest {
    @TempDir
    public Path repositoryDirectory;
    @Mock
    private Watcher watcher;
    private final JsonHandler jsonHandler = new JsonHandlerFactory().create();
    @Mock
    private HtmlBuilderVisitor htmlBuilderVisitor;
    private FragmentDirectiveBuilder fragmentDirectiveBuilder;
    private Path fragmentFile;
    private Fragment fragment;
    private final TemplateEngine htmlBuilder = new TemplateEngine("fragmentDirectiveTemplate.hbs.js");

    FragmentDirectiveBuilderTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.fragmentDirectiveBuilder = new FragmentDirectiveBuilder(this.watcher, this.jsonHandler, this.htmlBuilderVisitor, Boolean.valueOf(true));
        this.fragmentFile = Files.createFile(this.repositoryDirectory.resolve("fragment.json"), new FileAttribute[0]);
        this.fragment = FragmentBuilder.aFragment().withName("aUnicornFragment").with(new Element[]{ComponentBuilder.anInput().build()}).build();
        Files.write(this.fragmentFile, this.jsonHandler.toJson((Object)this.fragment), new OpenOption[0]);
    }

    @Test
    void should_build_a_fragment_directive() throws Exception {
        Mockito.when((Object)this.htmlBuilderVisitor.build(Mockito.anyList())).thenReturn((Object)"<p>content</p>");
        this.fragmentDirectiveBuilder.build(this.fragmentFile);
        String directive = new String(Files.readAllBytes(this.repositoryDirectory.resolve("fragment.js")));
        Assertions.assertThat((String)directive).isEqualTo(this.generateDirective(this.fragment, "<p>content</p>"));
    }

    @Test
    void should_watch_given_directory_to_build_directives_on_change() throws Exception {
        Mockito.when((Object)this.htmlBuilderVisitor.build(Mockito.anyList())).thenReturn((Object)"");
        this.fragmentDirectiveBuilder.start(this.repositoryDirectory);
        ((Watcher)Mockito.verify((Object)this.watcher)).watch((Path)Mockito.eq((Object)this.repositoryDirectory), (PathListener)Mockito.any(PathListener.class));
    }

    @Test
    void should_not_watch_given_directory_when_live_build_is_disabled() throws Exception {
        Mockito.when((Object)this.htmlBuilderVisitor.build(Mockito.anyList())).thenReturn((Object)"");
        this.fragmentDirectiveBuilder = new FragmentDirectiveBuilder(this.watcher, this.jsonHandler, this.htmlBuilderVisitor, Boolean.valueOf(false));
        this.fragmentDirectiveBuilder.start(this.repositoryDirectory);
        ((Watcher)Mockito.verify((Object)this.watcher, (VerificationMode)Mockito.never())).watch((Path)Mockito.eq((Object)this.repositoryDirectory), (PathListener)Mockito.any(PathListener.class));
    }

    @Test
    void should_exclude_metadata_from_the_build() throws Exception {
        boolean isBuildable = this.fragmentDirectiveBuilder.isBuildable(".metadata/123.json");
        Assertions.assertThat((boolean)isBuildable).isFalse();
    }

    private String generateDirective(Fragment fragment, String content) throws IOException {
        return this.htmlBuilder.with("rowsHtml", (Object)content).build((Object)fragment);
    }
}

