/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.angularjs.GeneratorProperties;
import org.bonitasoft.web.angularjs.workspace.FragmentDirectiveBuilder;
import org.bonitasoft.web.angularjs.workspace.WidgetDirectiveBuilder;
import org.bonitasoft.web.designer.common.GeneratorStrategy;
import org.bonitasoft.web.designer.common.livebuild.AbstractLiveFileBuilder;
import org.bonitasoft.web.designer.common.repository.PageRepository;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.config.WorkspaceProperties;
import org.bonitasoft.web.designer.controller.importer.dependencies.AssetDependencyImporter;
import org.bonitasoft.web.designer.migration.LiveRepositoryUpdate;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonHandlerFactory;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.workspace.ResourcesCopier;
import org.bonitasoft.web.designer.workspace.Workspace;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
class WorkspaceInitializerTest {
    @TempDir
    public Path temporaryFolder;
    @TempDir
    public Path uidWorkspace;
    @Mock
    private LiveRepositoryUpdate<Page> pageRepositoryLiveUpdate;
    @Mock
    private LiveRepositoryUpdate<Widget> widgetRepositoryLiveUpdate;
    @Mock
    WidgetRepository widgetRepository;
    private Workspace workspace;
    @Mock
    private GeneratorStrategy generatorStrategy;

    WorkspaceInitializerTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        UiDesignerProperties uiDesignerProperties = this.newUiDesignerProperties();
        Mockito.when((Object)this.widgetRepository.resolvePath(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String id = (String)invocation.getArgument(0);
            return uiDesignerProperties.getWorkspace().getWidgets().getDir().resolve(id);
        });
        Mockito.when((Object)this.generatorStrategy.getGeneratorProperties()).thenReturn((Object)new GeneratorProperties(this.uidWorkspace));
        Mockito.when((Object)this.generatorStrategy.widgetFileBuilder()).thenReturn((Object)((AbstractLiveFileBuilder)Mockito.mock(WidgetDirectiveBuilder.class)));
        Mockito.when((Object)this.generatorStrategy.fragmentDirectiveBuilder()).thenReturn((Object)((AbstractLiveFileBuilder)Mockito.mock(FragmentDirectiveBuilder.class)));
        PageRepository pageRepository = (PageRepository)Mockito.mock(PageRepository.class);
        AssetDependencyImporter widgetAssetDependencyImporter = (AssetDependencyImporter)Mockito.mock(AssetDependencyImporter.class);
        ResourcesCopier resourcesCopier = new ResourcesCopier();
        List<LiveRepositoryUpdate<Page>> migrations = List.of(this.widgetRepositoryLiveUpdate, this.pageRepositoryLiveUpdate);
        JsonHandler jsonHandler = new JsonHandlerFactory().create();
        this.workspace = (Workspace)Mockito.spy((Object)new Workspace(uiDesignerProperties, this.widgetRepository, pageRepository, this.generatorStrategy, widgetAssetDependencyImporter, resourcesCopier, migrations, jsonHandler));
    }

    private UiDesignerProperties newUiDesignerProperties() throws IOException {
        UiDesignerProperties uiDesignerProperties = new UiDesignerProperties();
        uiDesignerProperties.setModelVersion("2.0");
        WorkspaceProperties workspaceProperties = uiDesignerProperties.getWorkspace();
        Path fakeProjectFolder = this.temporaryFolder;
        workspaceProperties.setPath(fakeProjectFolder);
        workspaceProperties.getPages().setDir(Files.createDirectory(this.temporaryFolder.resolve("pages"), new FileAttribute[0]));
        workspaceProperties.getWidgets().setDir(Files.createDirectory(this.temporaryFolder.resolve("widgets"), new FileAttribute[0]));
        workspaceProperties.getFragments().setDir(Files.createDirectory(this.temporaryFolder.resolve("fragments"), new FileAttribute[0]));
        return uiDesignerProperties;
    }

    @Test
    void should_initialize_workspace() throws Exception {
        this.workspace.initialize();
        ((Workspace)Mockito.verify((Object)this.workspace)).doInitialize();
        ((Workspace)Mockito.verify((Object)this.workspace)).cleanPageWorkspace();
        Assertions.assertThat((AtomicBoolean)this.workspace.initialized).isTrue();
    }

    @Test
    void should_start_page_live_migration() throws Exception {
        this.workspace.initialize();
        ((LiveRepositoryUpdate)Mockito.verify(this.pageRepositoryLiveUpdate)).start();
    }

    @Test
    void should_start_widget_live_migration() throws Exception {
        this.workspace.initialize();
        ((LiveRepositoryUpdate)Mockito.verify(this.widgetRepositoryLiveUpdate)).start();
    }

    @Test
    void should_throw_runtimeException_if_error_occurs_while_initializing_workspace() throws Exception {
        ((Workspace)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.workspace)).doInitialize();
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> this.workspace.initialize());
    }
}

