/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer;

import java.util.List;
import javax.validation.Validation;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.bonitasoft.web.angularjs.GeneratorProperties;
import org.bonitasoft.web.designer.ArtifactBuilderException;
import org.bonitasoft.web.designer.UiDesignerCore;
import org.bonitasoft.web.designer.common.livebuild.ObserverFactory;
import org.bonitasoft.web.designer.common.livebuild.Watcher;
import org.bonitasoft.web.designer.common.repository.AssetRepository;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedLoader;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedPersister;
import org.bonitasoft.web.designer.common.repository.PageRepository;
import org.bonitasoft.web.designer.common.repository.Repository;
import org.bonitasoft.web.designer.common.repository.WidgetFileBasedLoader;
import org.bonitasoft.web.designer.common.repository.WidgetFileBasedPersister;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.common.visitor.AssetVisitor;
import org.bonitasoft.web.designer.common.visitor.FragmentIdVisitor;
import org.bonitasoft.web.designer.common.visitor.WidgetIdVisitor;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.controller.importer.dependencies.AssetDependencyImporter;
import org.bonitasoft.web.designer.migration.AddModelVersionMigrationStep;
import org.bonitasoft.web.designer.migration.AddWebResourcesForWidget;
import org.bonitasoft.web.designer.migration.AssetExternalMigrationStep;
import org.bonitasoft.web.designer.migration.AssetIdMigrationStep;
import org.bonitasoft.web.designer.migration.DataExposedMigrationStep;
import org.bonitasoft.web.designer.migration.LocalizationAddErrorDialogTranslationsMigrationStep;
import org.bonitasoft.web.designer.migration.Migration;
import org.bonitasoft.web.designer.migration.SplitWidgetResourcesMigrationStep;
import org.bonitasoft.web.designer.migration.StyleAddErrorDialogPropertiesMigrationStep;
import org.bonitasoft.web.designer.migration.StyleAddModalContainerPropertiesMigrationStep;
import org.bonitasoft.web.designer.migration.StyleAssetMigrationStep;
import org.bonitasoft.web.designer.migration.StyleUpdateInputRequiredLabelMigrationStep;
import org.bonitasoft.web.designer.migration.StyleUpdateInputTypeMigrationStep;
import org.bonitasoft.web.designer.migration.page.AccessibilityCheckListAndRadioButtonsMigrationStep;
import org.bonitasoft.web.designer.migration.page.AutocompleteWidgetReturnedKeyMigrationStep;
import org.bonitasoft.web.designer.migration.page.BondMigrationStep;
import org.bonitasoft.web.designer.migration.page.BusinessVariableMigrationStep;
import org.bonitasoft.web.designer.migration.page.DataToVariableMigrationStep;
import org.bonitasoft.web.designer.migration.page.DynamicTabsContainerMigrationStep;
import org.bonitasoft.web.designer.migration.page.PageUUIDMigrationStep;
import org.bonitasoft.web.designer.migration.page.SetInterpretHtmlTrueMigrationStep;
import org.bonitasoft.web.designer.migration.page.TableWidgetInterpretHTMLMigrationStep;
import org.bonitasoft.web.designer.migration.page.TableWidgetStylesMigrationStep;
import org.bonitasoft.web.designer.migration.page.TextWidgetInterpretHTMLMigrationStep;
import org.bonitasoft.web.designer.migration.page.TextWidgetLabelMigrationStep;
import org.bonitasoft.web.designer.migration.page.UIBootstrapAssetMigrationStep;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.bonitasoft.web.designer.service.BondsTypesFixer;
import org.bonitasoft.web.designer.service.DefaultFragmentService;
import org.bonitasoft.web.designer.service.DefaultPageService;
import org.bonitasoft.web.designer.service.DefaultWidgetService;
import org.bonitasoft.web.designer.service.FragmentMigrationApplyer;
import org.bonitasoft.web.designer.service.PageMigrationApplyer;
import org.bonitasoft.web.designer.service.WidgetMigrationApplyer;
import org.bonitasoft.web.designer.visitor.ComponentVisitor;
import org.bonitasoft.web.designer.visitor.FragmentChangeVisitor;
import org.bonitasoft.web.designer.visitor.PageHasValidationErrorVisitor;
import org.bonitasoft.web.designer.visitor.VisitorFactory;
import org.bonitasoft.web.designer.visitor.WebResourcesVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiDesignerCoreFactory {
    private static final Logger log = LoggerFactory.getLogger(UiDesignerCoreFactory.class);
    private final UiDesignerProperties uiDesignerProperties;
    private final JsonHandler jsonHandler;
    private final BeanValidator beanValidator;
    private GeneratorProperties generatorProperties;

    public UiDesignerCoreFactory(UiDesignerProperties uiDesignerProperties, GeneratorProperties generatorProperties, JsonHandler jsonHandler) {
        this.uiDesignerProperties = uiDesignerProperties;
        this.generatorProperties = generatorProperties;
        this.jsonHandler = jsonHandler;
        this.beanValidator = new BeanValidator(Validation.buildDefaultValidatorFactory().getValidator());
    }

    public UiDesignerCore create() {
        Watcher watcher = this.createWatcher(this.createFileMonitor(false));
        WidgetRepository widgetRepository = this.createWidgetRepository(watcher);
        AssetRepository<Widget> widgetAssetRepository = this.createWidgetAssetRepository(widgetRepository);
        FragmentRepository fragmentRepository = this.createFragmentRepository(watcher);
        PageRepository pageRepository = this.createPageRepository(watcher);
        AssetRepository<Page> pageAssetRepository = this.createPageAssetRepository(pageRepository);
        return this.create(watcher, widgetRepository, widgetAssetRepository, fragmentRepository, pageRepository, pageAssetRepository);
    }

    public UiDesignerCore create(Watcher watcher, WidgetRepository widgetRepository, AssetRepository<Widget> widgetAssetRepository, FragmentRepository fragmentRepository, PageRepository pageRepository, AssetRepository<Page> pageAssetRepository) {
        AssetDependencyImporter<Page> pageAssetDependencyImporter = new AssetDependencyImporter<Page>(pageAssetRepository);
        AssetService<Page> pageAssetService = new AssetService<Page>((Repository<Page>)pageRepository, pageAssetRepository, pageAssetDependencyImporter);
        ComponentVisitor componentVisitor = new ComponentVisitor(fragmentRepository);
        List<Migration<Fragment>> fragmentMigrationStepsList = List.of(new Migration("1.0.3", new BondMigrationStep(componentVisitor, widgetRepository, new VisitorFactory())), new Migration("1.7.25", new TextWidgetInterpretHTMLMigrationStep(componentVisitor)), new Migration("1.9.24", new TextWidgetLabelMigrationStep(componentVisitor)), new Migration("1.10.12", new DataToVariableMigrationStep()), new Migration("1.10.16", new TableWidgetInterpretHTMLMigrationStep(componentVisitor)), new Migration("1.10.18", new TableWidgetStylesMigrationStep(componentVisitor)), new Migration("1.11.46", new DataExposedMigrationStep()), new Migration("2.0", new AddModelVersionMigrationStep("INITIAL_MODEL_VERSION")), new Migration("2.1", new AddModelVersionMigrationStep("2.1"), new AutocompleteWidgetReturnedKeyMigrationStep(componentVisitor)), new Migration("2.2", new AddModelVersionMigrationStep("2.2"), new BusinessVariableMigrationStep()), new Migration("2.3", new SetInterpretHtmlTrueMigrationStep(componentVisitor)), new Migration("2.4", new AccessibilityCheckListAndRadioButtonsMigrationStep(componentVisitor)), new Migration("2.5", new AddModelVersionMigrationStep("2.5")), new Migration("2.6", new AddModelVersionMigrationStep("2.6")));
        List<Migration<Page>> pageMigrationStepsList = List.of(new Migration("1.0.2", new AssetIdMigrationStep()), new Migration("1.0.3", new BondMigrationStep(componentVisitor, widgetRepository, new VisitorFactory())), new Migration("1.2.9", new AssetExternalMigrationStep()), new Migration("1.5.7", new StyleAssetMigrationStep(this.generatorProperties.getExtractPath(), pageAssetService)), new Migration("1.5.10", new UIBootstrapAssetMigrationStep(pageAssetService, componentVisitor, widgetRepository)), new Migration("1.7.4", new TextWidgetInterpretHTMLMigrationStep(componentVisitor)), new Migration("1.7.25", new PageUUIDMigrationStep()), new Migration("1.8.29", new StyleAddModalContainerPropertiesMigrationStep(pageAssetService)), new Migration("1.9.24", new TextWidgetLabelMigrationStep(componentVisitor)), new Migration("1.10.5", new DynamicTabsContainerMigrationStep()), new Migration("1.10.12", new DataToVariableMigrationStep()), new Migration("1.10.16", new TableWidgetInterpretHTMLMigrationStep(componentVisitor)), new Migration("1.10.18", new TableWidgetStylesMigrationStep(componentVisitor)), new Migration("1.11.40", new BusinessVariableMigrationStep()), new Migration("1.11.46", new StyleUpdateInputRequiredLabelMigrationStep(pageAssetService)), new Migration("2.0", new AddModelVersionMigrationStep("2.0"), new AutocompleteWidgetReturnedKeyMigrationStep(componentVisitor)), new Migration("2.1", new AddModelVersionMigrationStep("2.1")), new Migration("2.2", new AddModelVersionMigrationStep("2.2")), new Migration("2.3", new SetInterpretHtmlTrueMigrationStep(componentVisitor)), new Migration("2.4", new AccessibilityCheckListAndRadioButtonsMigrationStep(componentVisitor)), new Migration("2.5", new StyleUpdateInputTypeMigrationStep(pageAssetService)), new Migration("2.6", new StyleAddErrorDialogPropertiesMigrationStep(pageAssetService), new LocalizationAddErrorDialogTranslationsMigrationStep(pageAssetService)));
        List<Migration<Widget>> widgetMigrationStepsList = List.of(new Migration("1.0.2", new AssetIdMigrationStep()), new Migration("1.2.9", new AssetExternalMigrationStep()), new Migration("1.10.12", new SplitWidgetResourcesMigrationStep()), new Migration("2.0", new AddModelVersionMigrationStep("2.0")), new Migration("2.1", new AddModelVersionMigrationStep("2.1")), new Migration("2.2", new AddModelVersionMigrationStep("2.2")), new Migration("2.3", new AddModelVersionMigrationStep("2.3")), new Migration("2.4", new AddModelVersionMigrationStep("2.4"), new AddWebResourcesForWidget()), new Migration("2.5", new AddModelVersionMigrationStep("2.5")), new Migration("2.6", new AddModelVersionMigrationStep("2.6")));
        WidgetMigrationApplyer widgetMigrationApplyer = new WidgetMigrationApplyer(widgetMigrationStepsList);
        WidgetIdVisitor widgetIdVisitor = new WidgetIdVisitor(fragmentRepository);
        AssetVisitor assetVisitor = new AssetVisitor(widgetRepository, fragmentRepository);
        AssetDependencyImporter<Widget> widgetAssetDependencyImporter = new AssetDependencyImporter<Widget>(widgetAssetRepository);
        AssetService<Widget> widgetAssetService = new AssetService<Widget>((Repository<Widget>)widgetRepository, widgetAssetRepository, widgetAssetDependencyImporter);
        DefaultWidgetService widgetService = new DefaultWidgetService(widgetRepository, pageRepository, fragmentRepository, List.of(new BondsTypesFixer(pageRepository), new BondsTypesFixer(fragmentRepository)), widgetMigrationApplyer, widgetIdVisitor, assetVisitor, this.uiDesignerProperties, widgetAssetService);
        FragmentMigrationApplyer fragmentMigrationApplyer = new FragmentMigrationApplyer(fragmentMigrationStepsList, widgetService);
        DefaultFragmentService fragmentService = new DefaultFragmentService(fragmentRepository, pageRepository, fragmentMigrationApplyer, new FragmentIdVisitor(fragmentRepository), new FragmentChangeVisitor(), new PageHasValidationErrorVisitor(), assetVisitor, this.uiDesignerProperties, new WebResourcesVisitor(fragmentRepository, widgetRepository));
        PageMigrationApplyer pageMigrationApplyer = new PageMigrationApplyer(pageMigrationStepsList, widgetService, fragmentService);
        DefaultPageService pageService = new DefaultPageService(pageRepository, pageMigrationApplyer, new ComponentVisitor(fragmentRepository), assetVisitor, this.uiDesignerProperties, pageAssetService, new WebResourcesVisitor(fragmentRepository, widgetRepository));
        return new UiDesignerCore(watcher, pageRepository, pageAssetRepository, pageService, pageAssetService, fragmentRepository, fragmentService, widgetRepository, widgetAssetRepository, widgetService, widgetAssetService, pageMigrationStepsList, fragmentMigrationStepsList, widgetMigrationStepsList, widgetAssetDependencyImporter);
    }

    public FileAlterationMonitor createFileMonitor(boolean managed) {
        FileAlterationMonitor monitor = new FileAlterationMonitor(1000L);
        if (!managed) {
            try {
                monitor.start();
            }
            catch (Exception e) {
                throw new ArtifactBuilderException("Failed to start FileAlterationMonitor", e);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    monitor.stop();
                }
                catch (Exception e) {
                    log.warn("Failed to cleanly stop FileAlterationMonitor on shutdown", (Throwable)e);
                }
            }));
        }
        return monitor;
    }

    public Watcher createWatcher(FileAlterationMonitor monitor) {
        return new Watcher(new ObserverFactory(), monitor);
    }

    public AssetRepository<Page> createPageAssetRepository(PageRepository pageRepository) {
        return new AssetRepository((Repository)pageRepository, this.beanValidator);
    }

    public PageRepository createPageRepository(Watcher watcher) {
        return new PageRepository(this.uiDesignerProperties.getWorkspace().getPages().getDir(), this.generatorProperties.getTemplateResourcesPath(), new JsonFileBasedPersister(this.jsonHandler, this.beanValidator, this.uiDesignerProperties.getVersion(), this.uiDesignerProperties.getModelVersion()), new JsonFileBasedLoader(this.jsonHandler, Page.class), this.beanValidator, watcher);
    }

    public FragmentRepository createFragmentRepository(Watcher watcher) {
        return new FragmentRepository(this.uiDesignerProperties.getWorkspace().getFragments().getDir(), this.generatorProperties.getTemplateResourcesPath(), new JsonFileBasedPersister(this.jsonHandler, this.beanValidator, this.uiDesignerProperties.getVersion(), this.uiDesignerProperties.getModelVersion()), new JsonFileBasedLoader(this.jsonHandler, Fragment.class), this.beanValidator, watcher);
    }

    public AssetRepository<Widget> createWidgetAssetRepository(WidgetRepository widgetRepository) {
        return new AssetRepository((Repository)widgetRepository, this.beanValidator);
    }

    public WidgetRepository createWidgetRepository(Watcher watcher) {
        return new WidgetRepository(this.uiDesignerProperties.getWorkspace().getWidgets().getDir(), this.generatorProperties.getTemplateResourcesPath(), (JsonFileBasedPersister)new WidgetFileBasedPersister(this.jsonHandler, this.beanValidator, this.uiDesignerProperties.getVersion(), this.uiDesignerProperties.getModelVersion()), (JsonFileBasedLoader)new WidgetFileBasedLoader(this.jsonHandler), this.beanValidator, watcher);
    }

    public UiDesignerProperties getUiDesignerProperties() {
        return this.uiDesignerProperties;
    }

    public JsonHandler getJsonHandler() {
        return this.jsonHandler;
    }

    public BeanValidator getBeanValidator() {
        return this.beanValidator;
    }

    public GeneratorProperties getGeneratorProperties() {
        return this.generatorProperties;
    }
}

