/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.web.designer.common.repository.RefreshingRepository;
import org.bonitasoft.web.designer.common.repository.Repository;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.migration.Migration;
import org.bonitasoft.web.designer.model.DesignerArtifact;
import org.bonitasoft.web.designer.model.Identifiable;

public class LiveRepositoryUpdate<A extends DesignerArtifact>
implements Comparable<LiveRepositoryUpdate<A>> {
    private final Repository<A> repository;
    private final List<Migration<A>> migrationList;

    public LiveRepositoryUpdate(Repository<A> repository, List<Migration<A>> migrationList) {
        this.repository = repository;
        this.migrationList = migrationList;
    }

    public void start() throws IOException {
        this.repository.walk((FileVisitor)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                LiveRepositoryUpdate.this.refresh(LiveRepositoryUpdate.this.repository, path.toFile().toPath());
                return FileVisitResult.CONTINUE;
            }
        });
        this.repository.watch(path -> this.refresh(this.repository, path));
    }

    public void migrate() throws IOException {
        this.repository.walk((FileVisitor)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                if (LiveRepositoryUpdate.this.isArtifactDescriptor(path)) {
                    DesignerArtifact artifact = (DesignerArtifact)LiveRepositoryUpdate.this.repository.get(path);
                    String formerArtifactVersion = artifact.getArtifactVersion();
                    for (Migration<DesignerArtifact> migration : LiveRepositoryUpdate.this.migrationList) {
                        migration.migrate(artifact);
                    }
                    if (!StringUtils.equals((CharSequence)formerArtifactVersion, (CharSequence)artifact.getArtifactVersion())) {
                        artifact.setPreviousArtifactVersion(formerArtifactVersion);
                        LiveRepositoryUpdate.this.repository.updateLastUpdateAndSave((Identifiable)artifact);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void refresh(Repository<A> repository, Path path) {
        if (repository instanceof RefreshingRepository && this.isArtifactDescriptor(path)) {
            DesignerArtifact page = (DesignerArtifact)repository.get(path);
            ((RefreshingRepository)repository).refresh(page.getId());
        }
    }

    private boolean isArtifactDescriptor(Path path) {
        return path.toString().endsWith(".json") && !StringUtils.contains((CharSequence)path.toString(), (CharSequence)(File.separator + ".metadata" + File.separator)) && !StringUtils.contains((CharSequence)path.toString(), (CharSequence)(File.separator + "assets" + File.separator));
    }

    @Override
    public int compareTo(LiveRepositoryUpdate o) {
        return this.repository instanceof WidgetRepository ? -1 : 1;
    }
}

